/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.CompletionHandler;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.api.transport.ReplyToHandler;
import org.mule.construct.Flow;
import org.mule.processor.AbstractNonBlockingMessageProcessor;
import org.mule.processor.NonBlockingMessageProcessor;
import org.mule.processor.strategy.NonBlockingProcessingStrategy;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.SensingNullReplyToHandler;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class NonBlockingMessageProcessorTestCase
extends AbstractMuleContextTestCase {
    private NonBlockingMessageProcessor nonBlockingMessageProcessor = new TestNonBlockingProcessor();

    @Test
    public void blockingProcess() throws MuleException, Exception {
        MuleEvent request = NonBlockingMessageProcessorTestCase.getTestEventUsingFlow("Test Message");
        MuleEvent response = this.nonBlockingMessageProcessor.process(request);
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.equalTo((Object)request));
    }

    @Test
    public void nonBlockingProcessVoidMuleEventResponse() throws MuleException, Exception {
        MuleEvent request = this.createNonBlockingTestEvent();
        MuleEvent response = this.nonBlockingMessageProcessor.process(request);
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NonBlockingVoidMuleEvent.class)));
    }

    @Test
    public void clearRequestContextAfterNonBlockingProcess() throws MuleException, Exception {
        MuleEvent request = this.createNonBlockingTestEvent();
        OptimizedRequestContext.unsafeSetEvent((MuleEvent)request);
        MuleEvent response = this.nonBlockingMessageProcessor.process(request);
        Assert.assertThat((Object)RequestContext.getEvent(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private MuleEvent createNonBlockingTestEvent() throws Exception {
        Flow flow = MuleTestUtils.getTestFlow(muleContext);
        flow.setProcessingStrategy((ProcessingStrategy)new NonBlockingProcessingStrategy());
        return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext), MessageExchangePattern.REQUEST_RESPONSE, (ReplyToHandler)new SensingNullReplyToHandler(), (FlowConstruct)flow);
    }

    private class TestNonBlockingProcessor
    extends AbstractNonBlockingMessageProcessor {
        private TestNonBlockingProcessor() {
        }

        protected MuleEvent processBlocking(MuleEvent event) throws MuleException {
            return event;
        }

        public void processNonBlocking(MuleEvent event, CompletionHandler completionHandler) {
        }
    }
}

