/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.Service;
import org.mule.api.store.ObjectStore;
import org.mule.routing.IdempotentSecureHashMessageFilter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.store.InMemoryObjectStore;

public class IdempotentSecureHashMessageFilterTestCase
extends AbstractMuleContextTestCase {
    public IdempotentSecureHashMessageFilterTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testIdempotentReceiver() throws Exception {
        InboundEndpoint endpoint1 = IdempotentSecureHashMessageFilterTestCase.getTestInboundEndpoint("Test1Provider", "test://Test1Provider?exchangePattern=one-way");
        Service service = IdempotentSecureHashMessageFilterTestCase.getTestService();
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        Mockito.when((Object)session.getFlowConstruct()).thenReturn((Object)service);
        IdempotentSecureHashMessageFilter ir = new IdempotentSecureHashMessageFilter();
        ir.setFlowConstruct((FlowConstruct)service);
        ir.setThrowOnUnaccepted(false);
        ir.setStorePrefix("foo");
        ir.setStore((ObjectStore)new InMemoryObjectStore());
        ir.setMuleContext(muleContext);
        DefaultMuleMessage okMessage = new DefaultMuleMessage((Object)"OK", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)okMessage, endpoint1, (FlowConstruct)IdempotentSecureHashMessageFilterTestCase.getTestService(), session);
        event = ir.process((MuleEvent)event);
        Assert.assertNotNull((Object)event);
        okMessage = new DefaultMuleMessage((Object)"OK", muleContext);
        event = new DefaultMuleEvent((MuleMessage)okMessage, endpoint1, (FlowConstruct)IdempotentSecureHashMessageFilterTestCase.getTestService(), session);
        event = ir.process((MuleEvent)event);
        Assert.assertNull((Object)event);
        okMessage = new DefaultMuleMessage((Object)"Not OK", muleContext);
        event = new DefaultMuleEvent((MuleMessage)okMessage, endpoint1, (FlowConstruct)IdempotentSecureHashMessageFilterTestCase.getTestService(), session);
        event = ir.process((MuleEvent)event);
        Assert.assertNotNull((Object)event);
    }
}

