/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.filters.EqualsFilter;
import org.mule.routing.filters.WildcardFilter;
import org.mule.routing.filters.logic.AndFilter;
import org.mule.routing.filters.logic.NotFilter;
import org.mule.routing.filters.logic.OrFilter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class LogicFiltersTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testAndFilter() {
        AndFilter filter = new AndFilter();
        Assert.assertEquals((long)0L, (long)filter.getFilters().size());
        Assert.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"foo", muleContext)));
        filter.getFilters().add(new EqualsFilter((Object)"foo"));
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"foo", muleContext)));
        filter.getFilters().add(new EqualsFilter((Object)"foo"));
        Assert.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"bar", muleContext)));
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"foo", muleContext)));
        WildcardFilter left = new WildcardFilter("blah.blah.*");
        WildcardFilter right = new WildcardFilter("blah.*");
        filter = new AndFilter(new Filter[]{left, right});
        Assert.assertEquals((long)2L, (long)filter.getFilters().size());
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah", muleContext)));
        Assert.assertTrue((boolean)right.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah", muleContext)));
        Assert.assertTrue((!left.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah", muleContext)) ? 1 : 0) != 0);
        Assert.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah", muleContext)) ? 1 : 0) != 0);
        filter = new AndFilter();
        filter.getFilters().add(left);
        filter.getFilters().add(right);
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah", muleContext)));
        Assert.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah", muleContext)) ? 1 : 0) != 0);
    }

    @Test
    public void testOrFilter() {
        OrFilter filter = new OrFilter();
        Assert.assertEquals((long)0L, (long)filter.getFilters().size());
        Assert.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"foo", muleContext)));
        WildcardFilter left = new WildcardFilter("blah.blah.*");
        WildcardFilter right = new WildcardFilter("blah.b*");
        filter = new OrFilter(new Filter[]{left, right});
        Assert.assertEquals((long)2L, (long)filter.getFilters().size());
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah", muleContext)));
        Assert.assertTrue((boolean)right.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah", muleContext)));
        Assert.assertTrue((!left.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah", muleContext)) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah", muleContext)));
        Assert.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.x.blah", muleContext)) ? 1 : 0) != 0);
        filter = new OrFilter();
        LinkedList<WildcardFilter> filters = new LinkedList<WildcardFilter>();
        filters.addLast(left);
        filters.addLast(right);
        filter.setFilters(filters);
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah", muleContext)));
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah", muleContext)));
        Assert.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.x.blah", muleContext)) ? 1 : 0) != 0);
    }

    @Test
    public void testNotFilter() {
        NotFilter notFilter = new NotFilter();
        Assert.assertNull((Object)notFilter.getFilter());
        Assert.assertFalse((boolean)notFilter.accept((MuleMessage)new DefaultMuleMessage((Object)"foo", muleContext)));
        Assert.assertFalse((boolean)notFilter.accept((MuleMessage)new DefaultMuleMessage(null, muleContext)));
        WildcardFilter filter = new WildcardFilter("blah.blah.*");
        notFilter = new NotFilter((Filter)filter);
        Assert.assertNotNull((Object)notFilter.getFilter());
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah", muleContext)));
        Assert.assertTrue((!notFilter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah", muleContext)) ? 1 : 0) != 0);
        notFilter = new NotFilter();
        notFilter.setFilter((Filter)filter);
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah", muleContext)));
        Assert.assertTrue((!notFilter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah", muleContext)) ? 1 : 0) != 0);
    }
}

