/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.routing.outbound.StaticRecipientList;
import org.mule.tck.MuleEventCheckAnswer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class StaticRecipientListRouterTestCase
extends AbstractMuleContextTestCase {
    public StaticRecipientListRouterTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testRecipientListRouterAsync() throws Exception {
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        OutboundEndpoint endpoint1 = StaticRecipientListRouterTestCase.getTestOutboundEndpoint("Test1Provider");
        Assert.assertNotNull((Object)endpoint1);
        OutboundEndpoint mockendpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        ArrayList<String> recipients = new ArrayList<String>();
        String recipient1 = "test://recipient1";
        recipients.add(recipient1);
        String recipient2 = "test://recipient2";
        recipients.add(recipient2);
        MockingStaticRecipientList router = this.createObject(MockingStaticRecipientList.class);
        router.setRecipients(recipients);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(mockendpoint1);
        router.setRoutes(endpoints);
        router.setMuleContext(muleContext);
        Assert.assertEquals((long)2L, (long)router.getRecipients().size());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
        router.setMockEndpointListener(new MockEndpointListener(){

            @Override
            public void mockEndpointAdded(OutboundEndpoint recipient) throws MuleException {
                Mockito.when((Object)recipient.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
            }
        });
        router.route(new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
    }

    @Test
    public void testRecipientListRouterSync() throws Exception {
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        OutboundEndpoint endpoint1 = StaticRecipientListRouterTestCase.getTestOutboundEndpoint("Test1Provider");
        Assert.assertNotNull((Object)endpoint1);
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add("test://recipient1?exchangePattern=request-response");
        recipients.add("test://recipient2?exchangePattern=request-response");
        MockingStaticRecipientList router = this.createObject(MockingStaticRecipientList.class);
        router.setRecipients(recipients);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        router.setRoutes(endpoints);
        router.setMuleContext(muleContext);
        Assert.assertEquals((long)2L, (long)router.getRecipients().size());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
        message = new DefaultMuleMessage((Object)"test event", muleContext);
        final OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        router.setMockEndpointListener(new MockEndpointListener(){

            @Override
            public void mockEndpointAdded(OutboundEndpoint recipient) throws MuleException {
                Mockito.when((Object)recipient.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
            }
        });
        router.getRecipients().add("test://recipient3?exchangePattern=request-response");
        MuleEvent result = router.route(new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        Assert.assertNotNull((Object)result);
        MuleMessage resultMessage = result.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        Assert.assertTrue((boolean)(resultMessage.getPayload() instanceof List));
        Assert.assertEquals((long)3L, (long)((List)resultMessage.getPayload()).size());
    }

    @Test
    public void testBadRecipientListRouter() throws Exception {
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        OutboundEndpoint endpoint1 = StaticRecipientListRouterTestCase.getTestOutboundEndpoint("Test1Provider");
        Assert.assertNotNull((Object)endpoint1);
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add("malformed-endpointUri-recipient1");
        StaticRecipientList router = this.createObject(StaticRecipientList.class);
        router.setRecipients(recipients);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        router.setRoutes(endpoints);
        Assert.assertEquals((long)1L, (long)router.getRecipients().size());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
        try {
            router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
            Assert.fail((String)"Should not allow malformed endpointUri");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static interface MockEndpointListener {
        public void mockEndpointAdded(OutboundEndpoint var1) throws MuleException;
    }

    public static class MockingStaticRecipientList
    extends StaticRecipientList {
        private Map<String, OutboundEndpoint> recipients = new HashMap<String, OutboundEndpoint>();
        private MockEndpointListener listener;

        OutboundEndpoint getRecipient(String name) {
            return this.recipients.get(name);
        }

        public void setMockEndpointListener(MockEndpointListener listener) {
            this.listener = listener;
        }

        protected OutboundEndpoint getRecipientEndpointFromString(MuleMessage message, String recipient) throws MuleException {
            OutboundEndpoint endpoint = super.getRecipientEndpointFromString(message, recipient);
            if (!this.recipients.containsKey(recipient)) {
                OutboundEndpoint mock = RouterTestUtils.createMockEndpoint(endpoint);
                this.recipients.put(recipient, mock);
                if (this.listener != null) {
                    this.listener.mockEndpointAdded(mock);
                }
            }
            return this.recipients.get(recipient);
        }
    }
}

