/*
 * Decompiled with CFR 0.152.
 */
package org.mule.streaming;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.apache.commons.collections.CollectionUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.streaming.ListableObjectStoreProducer;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ListableObjectStoreProducerTestCase {
    @Mock
    private ListableObjectStore<Serializable> objectStore;
    private Map<String, String> values;
    private ListableObjectStoreProducer<Serializable> producer;

    @Before
    public void setUp() throws Exception {
        this.values = new HashMap<String, String>();
        this.values.put("fruit", "banana");
        this.values.put("icecream", "chocolate");
        this.values.put("drink", "coke");
        Mockito.when((Object)this.objectStore.retrieve((Serializable)((Object)Mockito.anyString()))).thenAnswer((Answer)new Answer<Serializable>(){

            public Serializable answer(InvocationOnMock invocation) throws Throwable {
                Serializable value = (Serializable)ListableObjectStoreProducerTestCase.this.values.get(invocation.getArguments()[0]);
                if (value == null) {
                    throw new ObjectDoesNotExistException();
                }
                return value;
            }
        });
        Mockito.when((Object)this.objectStore.allKeys()).thenReturn(new ArrayList<String>(this.values.keySet()));
        this.producer = new ListableObjectStoreProducer(this.objectStore);
    }

    @Test
    public void happyPath() throws Exception {
        HashSet<Serializable> returnedValues = new HashSet<Serializable>();
        Serializable item = this.producer.produce();
        while (item != null) {
            returnedValues.add(item);
            item = this.producer.produce();
        }
        Assert.assertEquals((int)returnedValues.size(), (int)this.values.size());
        for (String value : this.values.values()) {
            Assert.assertTrue((boolean)returnedValues.contains(value));
        }
        Assert.assertNull((Object)this.producer.produce());
    }

    @Test
    public void concurrentlyRemoved() throws Exception {
        this.values.remove("icecream");
        this.happyPath();
    }

    @Test
    public void size() throws Exception {
        Assert.assertEquals((int)this.values.size(), (int)this.producer.size());
    }

    @Test
    public void earlyClose() throws Exception {
        this.producer.produce();
        this.producer.close();
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)((List)((Object)this.producer.produce()))));
    }
}

