/*
 * Decompiled with CFR 0.152.
 */
package org.mule.streaming;

import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.streaming.PagingDelegate;
import org.mule.streaming.PagingDelegateProducer;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class PagingDelegateProducerTestCase {
    @Mock
    private PagingDelegate<String> delegate;
    private PagingDelegateProducer<String> producer;

    @Before
    public void setUp() {
        this.producer = new PagingDelegateProducer(this.delegate);
    }

    @Test
    public void produce() throws Exception {
        ArrayList page = new ArrayList();
        Mockito.when((Object)this.delegate.getPage()).thenReturn(page);
        Assert.assertSame(page, (Object)this.producer.produce());
    }

    @Test
    public void totalAvailable() {
        int total = 10;
        Mockito.when((Object)this.delegate.getTotalResults()).thenReturn((Object)10);
        Assert.assertEquals((int)this.producer.size(), (int)10);
    }

    @Test
    public void closeQuietly() throws MuleException {
        this.producer.close();
        ((PagingDelegate)Mockito.verify(this.delegate)).close();
    }

    @Test(expected=MuleException.class)
    public void closeNoisely() throws MuleException {
        ((PagingDelegate)Mockito.doThrow((Throwable)new DefaultMuleException((Throwable)new Exception())).when(this.delegate)).close();
        this.producer.close();
    }
}

