/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.simple.ParseTemplateTransformer;
import org.mule.util.IOUtils;

@SmallTest
public class ParseTemplateTransformerTestCase {
    private static final String LOCATION = "error.html";
    private static final String INVALID_LOCATION = "wrong_error.html";
    private ParseTemplateTransformer parseTemplateTransformer;
    private MuleMessage mockMuleMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private ExpressionManager mockExpressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);

    @Before
    public void setUp() {
        this.parseTemplateTransformer = new ParseTemplateTransformer();
        this.parseTemplateTransformer.setMuleContext(this.mockMuleContext);
        Mockito.when((Object)this.mockMuleContext.getExpressionManager()).thenReturn((Object)this.mockExpressionManager);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseTemplateNullTemplate() throws TransformerException, InitialisationException {
        this.parseTemplateTransformer.setLocation(LOCATION);
        this.parseTemplateTransformer.transformMessage(this.mockMuleMessage, "UTF-8");
    }

    @Test(expected=InitialisationException.class)
    public void testParseTemplateNullLocation() throws TransformerException, InitialisationException {
        this.parseTemplateTransformer.setLocation(null);
        this.parseTemplateTransformer.initialise();
        this.parseTemplateTransformer.transformMessage(this.mockMuleMessage, "UTF-8");
    }

    @Test(expected=InitialisationException.class)
    public void testParseTemplateInvalidLocation() throws TransformerException, InitialisationException {
        this.parseTemplateTransformer.setLocation(INVALID_LOCATION);
        this.parseTemplateTransformer.initialise();
        this.parseTemplateTransformer.transformMessage(this.mockMuleMessage, "UTF-8");
    }

    @Test
    public void testParseTemplate() throws TransformerException, InitialisationException, IOException {
        this.parseTemplateTransformer.setLocation(LOCATION);
        this.parseTemplateTransformer.initialise();
        Mockito.when((Object)this.mockMuleMessage.getInboundProperty("errorMessage")).thenReturn((Object)"ERROR!!!");
        String expectedExpression = IOUtils.getResourceAsString((String)LOCATION, this.getClass());
        Mockito.when((Object)this.mockExpressionManager.parse(expectedExpression, this.mockMuleMessage)).thenReturn((Object)"Parsed");
        Object response = this.parseTemplateTransformer.transformMessage(this.mockMuleMessage, "UTF-8");
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"Parsed", (Object)response);
        response = this.parseTemplateTransformer.transformMessage(this.mockMuleMessage, "UTF-8");
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"Parsed", (Object)response);
    }
}

