/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.transformer.DataType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.simple.SetPayloadMessageProcessor;
import org.mule.transformer.types.TypedValue;
import org.mule.transport.NullPayload;

public class SetPayloadMessageProcessorTestCase
extends AbstractMuleTestCase {
    private static final String PLAIN_TEXT = "This is a plain text";
    private static final String EXPRESSION = "#[testVariable]";
    private static final String CUSTOM_ENCODING = "UTF-16";
    private SetPayloadMessageProcessor setPayloadMessageProcessor;
    private MuleContext muleContext;
    private MuleMessage muleMessage;
    private MuleEvent muleEvent;
    private ExpressionManager expressionManager;
    private final ArgumentCaptor<DataType> actualDataType = ArgumentCaptor.forClass(DataType.class);
    private final ArgumentCaptor<Object> actualValue = ArgumentCaptor.forClass(Object.class);

    @Before
    public void setUp() {
        this.setPayloadMessageProcessor = new SetPayloadMessageProcessor();
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        this.setPayloadMessageProcessor.setMuleContext(this.muleContext);
        this.expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        this.muleMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)this.muleContext.getExpressionManager()).thenReturn((Object)this.expressionManager);
        Mockito.when((Object)this.expressionManager.parse(org.mockito.Matchers.anyString(), (MuleMessage)org.mockito.Matchers.any(MuleMessage.class))).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return (String)invocation.getArguments()[0];
            }
        });
        this.muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        Mockito.when((Object)this.muleEvent.getMessage()).thenReturn((Object)this.muleMessage);
    }

    @Test
    public void returnsSameMuleEvent() throws MuleException {
        this.setPayloadMessageProcessor.setValue(PLAIN_TEXT);
        this.setPayloadMessageProcessor.initialise();
        MuleEvent response = this.setPayloadMessageProcessor.process(this.muleEvent);
        Assert.assertThat((Object)response, (Matcher)Is.is((Object)this.muleEvent));
    }

    @Test
    public void setsNullPayload() throws MuleException {
        this.setPayloadMessageProcessor.setValue(null);
        this.setPayloadMessageProcessor.initialise();
        this.setPayloadMessageProcessor.process(this.muleEvent);
        ((MuleMessage)Mockito.verify((Object)this.muleMessage)).setPayload(this.actualValue.capture(), (DataType)org.mockito.Matchers.any());
        Assert.assertTrue((boolean)(this.actualValue.getValue() instanceof NullPayload));
    }

    @Test
    public void setsPlainText() throws MuleException {
        this.setPayloadMessageProcessor.setValue(PLAIN_TEXT);
        this.setPayloadMessageProcessor.initialise();
        Mockito.when((Object)this.expressionManager.isExpression(PLAIN_TEXT)).thenReturn((Object)false);
        this.setPayloadMessageProcessor.process(this.muleEvent);
        ((MuleMessage)Mockito.verify((Object)this.muleMessage)).setPayload(this.actualValue.capture(), (DataType)org.mockito.Matchers.any());
        Assert.assertThat((Object)((String)this.actualValue.getValue()), (Matcher)Matchers.equalTo((Object)PLAIN_TEXT));
    }

    @Test
    public void setsExpressionPayload() throws MuleException {
        this.setPayloadMessageProcessor.setValue(EXPRESSION);
        Mockito.when((Object)this.expressionManager.isExpression(EXPRESSION)).thenReturn((Object)true);
        this.setPayloadMessageProcessor.initialise();
        TypedValue typedValue = new TypedValue((Object)PLAIN_TEXT, DataType.STRING_DATA_TYPE);
        Mockito.when((Object)this.expressionManager.evaluateTyped(EXPRESSION, this.muleMessage)).thenReturn((Object)typedValue);
        this.setPayloadMessageProcessor.process(this.muleEvent);
        ((MuleMessage)Mockito.verify((Object)this.muleMessage)).setPayload(this.actualValue.capture(), (DataType)org.mockito.Matchers.any());
        Assert.assertThat((Object)((String)this.actualValue.getValue()), (Matcher)Matchers.equalTo((Object)PLAIN_TEXT));
    }

    @Test
    public void setsDefaultDataTypeForNullPayload() throws MuleException {
        this.setPayloadMessageProcessor.setValue(null);
        this.setPayloadMessageProcessor.initialise();
        this.setPayloadMessageProcessor.process(this.muleEvent);
        ((MuleMessage)Mockito.verify((Object)this.muleMessage)).setPayload(org.mockito.Matchers.any(), (DataType)this.actualDataType.capture());
        Assert.assertThat((Object)this.actualDataType.getValue(), DataTypeMatcher.like(Object.class, "*/*", null));
    }

    @Test
    public void setsDefaultDataTypeForNonNullValue() throws MuleException {
        this.setPayloadMessageProcessor.setValue(PLAIN_TEXT);
        this.setPayloadMessageProcessor.initialise();
        this.setPayloadMessageProcessor.process(this.muleEvent);
        ((MuleMessage)Mockito.verify((Object)this.muleMessage)).setPayload(org.mockito.Matchers.any(), (DataType)this.actualDataType.capture());
        Assert.assertThat((Object)this.actualDataType.getValue(), DataTypeMatcher.like(String.class, "*/*", null));
    }

    @Test
    public void setsCustomEncoding() throws MuleException {
        this.setPayloadMessageProcessor.setValue(PLAIN_TEXT);
        this.setPayloadMessageProcessor.setEncoding(CUSTOM_ENCODING);
        this.setPayloadMessageProcessor.initialise();
        this.setPayloadMessageProcessor.process(this.muleEvent);
        ((MuleMessage)Mockito.verify((Object)this.muleMessage)).setPayload(org.mockito.Matchers.any(), (DataType)this.actualDataType.capture());
        Assert.assertThat((Object)this.actualDataType.getValue(), DataTypeMatcher.like(String.class, "*/*", CUSTOM_ENCODING));
    }

    @Test
    public void setsCustomMimeType() throws MuleException {
        this.setPayloadMessageProcessor.setValue(PLAIN_TEXT);
        this.setPayloadMessageProcessor.setMimeType("application/xml");
        this.setPayloadMessageProcessor.initialise();
        this.setPayloadMessageProcessor.process(this.muleEvent);
        ((MuleMessage)Mockito.verify((Object)this.muleMessage)).setPayload(org.mockito.Matchers.any(), (DataType)this.actualDataType.capture());
        Assert.assertThat((Object)this.actualDataType.getValue(), DataTypeMatcher.like(String.class, "application/xml", null));
    }
}

