/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.simple.SetPayloadTransformer;
import org.mule.transport.NullPayload;

@SmallTest
public class SetPayloadTransformerTestCase
extends AbstractMuleTestCase {
    private static final String PLAIN_TEXT = "This is a plain text";
    private static final String EXPRESSION = "#[testVariable]";
    private SetPayloadTransformer setPayloadTransformer;
    private MuleContext mockMuleContext;
    private MuleMessage mockMuleMessage;
    private ExpressionManager mockExpressionManager;

    @Before
    public void setUp() {
        this.setPayloadTransformer = new SetPayloadTransformer();
        this.mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
        this.setPayloadTransformer.setMuleContext(this.mockMuleContext);
        this.mockExpressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        this.mockMuleMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)this.mockMuleContext.getExpressionManager()).thenReturn((Object)this.mockExpressionManager);
        Mockito.when((Object)this.mockExpressionManager.parse(Matchers.anyString(), (MuleMessage)Mockito.any(MuleMessage.class))).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return (String)invocation.getArguments()[0];
            }
        });
    }

    @Test
    public void testSetPayloadTransformerNulValue() throws InitialisationException, TransformerException {
        this.setPayloadTransformer.setValue(null);
        this.setPayloadTransformer.initialise();
        Object response = this.setPayloadTransformer.transformMessage(this.mockMuleMessage, "UTF-8");
        Assert.assertTrue((boolean)(response instanceof NullPayload));
    }

    @Test
    public void testSetPayloadTransformerPlainText() throws InitialisationException, TransformerException {
        this.setPayloadTransformer.setValue(PLAIN_TEXT);
        this.setPayloadTransformer.initialise();
        Mockito.when((Object)this.mockExpressionManager.isExpression(PLAIN_TEXT)).thenReturn((Object)false);
        Object response = this.setPayloadTransformer.transformMessage(this.mockMuleMessage, "UTF-8");
        Assert.assertEquals((Object)PLAIN_TEXT, (Object)response);
    }

    @Test
    public void testSetPayloadTransformerExpression() throws InitialisationException, TransformerException {
        this.setPayloadTransformer.setValue(EXPRESSION);
        Mockito.when((Object)this.mockExpressionManager.isExpression(EXPRESSION)).thenReturn((Object)true);
        this.setPayloadTransformer.initialise();
        Mockito.when((Object)this.mockExpressionManager.evaluate(EXPRESSION, this.mockMuleMessage)).thenReturn((Object)PLAIN_TEXT);
        Object response = this.setPayloadTransformer.transformMessage(this.mockMuleMessage, "UTF-8");
        Assert.assertEquals((Object)PLAIN_TEXT, (Object)response);
    }
}

