/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.types;

import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.types.SimpleDataType;

@SmallTest
public class SimpleDataTypeTestCase
extends AbstractMuleTestCase {
    @Test
    public void acceptsSupportedEncoding() throws Exception {
        SimpleDataType dataType = new SimpleDataType(Object.class, null);
        dataType.setEncoding(StandardCharsets.UTF_8.name());
        MatcherAssert.assertThat((Object)dataType.getEncoding(), (Matcher)Matchers.equalTo((Object)StandardCharsets.UTF_8.name()));
    }

    @Test(expected=UnsupportedCharsetException.class)
    public void rejectsUnsupportedEncoding() throws Exception {
        SimpleDataType dataType = new SimpleDataType(Object.class, null);
        dataType.setEncoding("unsupportedEncoding");
    }

    @Test
    public void acceptsValidMimeType() throws Exception {
        SimpleDataType dataType = new SimpleDataType(Object.class, null);
        dataType.setMimeType("text/json");
        MatcherAssert.assertThat((Object)dataType.getMimeType(), (Matcher)Matchers.equalTo((Object)"text/json"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void rejectsValidMimeType() throws Exception {
        SimpleDataType dataType = new SimpleDataType(Object.class, null);
        dataType.setMimeType("invalidMimeType");
    }
}

