/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.concurrent.TimeUnit;
import javax.resource.spi.work.Work;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.MessageExchangePattern;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.transport.Connector;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.mule.TestMessageReceiver;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.util.concurrent.Latch;

public class MessageReceiverWorkManagerTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void workManagerRecreatedCorrectlyAfterRestart() throws Exception {
        final Latch workExecutedLatch = new Latch();
        AbstractMessageReceiver receiver = this.createMessageReceiver();
        Connector receiverConnector = receiver.getConnector();
        receiverConnector.stop();
        receiverConnector.start();
        receiver.getWorkManager().scheduleWork(new Work(){

            public void release() {
            }

            public void run() {
                workExecutedLatch.release();
            }
        });
        if (!workExecutedLatch.await(1000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Work should be executed and it was not");
        }
        receiverConnector.stop();
        receiverConnector.dispose();
    }

    private AbstractMessageReceiver createMessageReceiver() throws Exception {
        return new TestMessageReceiver((Connector)MessageReceiverWorkManagerTestCase.getTestConnector(), (FlowConstruct)Mockito.mock(FlowConstruct.class, (Answer)Answers.RETURNS_DEEP_STUBS.get()), MessageReceiverWorkManagerTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY));
    }
}

