/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.MessageDispatcher;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.AbstractConnector;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.AbstractMessageDispatcherFactory;

public class MuleMessageFactoryUsagePatternsTestCase
extends AbstractMuleContextTestCase {
    private OutboundEndpoint endpoint;
    private AbstractConnector connector;
    private MuleMessageFactory factoryFromConnector;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.endpoint = MuleMessageFactoryUsagePatternsTestCase.getTestOutboundEndpoint("test");
        this.connector = (AbstractConnector)this.endpoint.getConnector();
        this.factoryFromConnector = this.connector.getMuleMessageFactory();
    }

    @Test
    public void testSharedMuleMessageFactoryWithConnector() throws Exception {
        this.connector.setDispatcherFactory((MessageDispatcherFactory)new FakeDispatcherFactory());
        MockMessageDispatcher dispatcher = (MockMessageDispatcher)this.connector.getDispatcherFactory().create(this.endpoint);
        dispatcher.initialise();
        MuleMessageFactory factoryFromDispatcher = dispatcher.getMuleMessageFactory();
        Assert.assertNotNull((Object)factoryFromDispatcher);
        Assert.assertSame((Object)this.factoryFromConnector, (Object)factoryFromDispatcher);
    }

    @Test
    public void testMessageDispatcherCreatesOwnMuleMessageFactory() throws Exception {
        this.connector.setDispatcherFactory((MessageDispatcherFactory)new CustomDispatcherFactory());
        CustomMessageDispatcher dispatcher = (CustomMessageDispatcher)this.connector.getDispatcherFactory().create(this.endpoint);
        dispatcher.initialise();
        MuleMessageFactory factoryFromDispatcher = dispatcher.getMuleMessageFactory();
        Assert.assertNotNull((Object)factoryFromDispatcher);
        Assert.assertNotSame((Object)this.factoryFromConnector, (Object)factoryFromDispatcher);
    }

    private static class CustomMessageDispatcher
    extends AbstractMessageDispatcher {
        public CustomMessageDispatcher(OutboundEndpoint endpoint) {
            super(endpoint);
        }

        protected void initializeMessageFactory() throws InitialisationException {
            try {
                this.muleMessageFactory = this.connector.createMuleMessageFactory();
            }
            catch (CreateException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }

        public MuleMessageFactory getMuleMessageFactory() {
            return this.muleMessageFactory;
        }

        protected void doDispatch(MuleEvent event) throws Exception {
            throw new UnsupportedOperationException("doDispatch");
        }

        protected MuleMessage doSend(MuleEvent event) throws Exception {
            throw new UnsupportedOperationException("doSend");
        }
    }

    private static class MockMessageDispatcher
    extends AbstractMessageDispatcher {
        public MockMessageDispatcher(OutboundEndpoint endpoint) {
            super(endpoint);
        }

        public MuleMessageFactory getMuleMessageFactory() {
            return this.muleMessageFactory;
        }

        protected void doDispatch(MuleEvent event) throws Exception {
            throw new UnsupportedOperationException("doDispatch");
        }

        protected MuleMessage doSend(MuleEvent event) throws Exception {
            throw new UnsupportedOperationException("doSend");
        }
    }

    private static class CustomDispatcherFactory
    extends AbstractMessageDispatcherFactory {
        public MessageDispatcher create(OutboundEndpoint endpoint) throws MuleException {
            return new CustomMessageDispatcher(endpoint);
        }
    }

    private static class FakeDispatcherFactory
    extends AbstractMessageDispatcherFactory {
        public MessageDispatcher create(OutboundEndpoint endpoint) throws MuleException {
            return new MockMessageDispatcher(endpoint);
        }
    }
}

