/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractConnector;
import org.mule.transport.TransactedPollingMessageReceiver;

@RunWith(value=MockitoJUnitRunner.class)
public class TransactedPollingMessageReceiverTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private AbstractConnector mockConnector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private FlowConstruct mockFlowConstruct;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private InboundEndpoint mockEndpoint;
    @Mock
    private static ExecutionTemplate<MuleEvent> executionTemplate;

    @Test
    public void callSystemExceptionHandlerReceivingMessage() throws Exception {
        Mockito.when((Object)this.mockEndpoint.getConnector()).thenReturn((Object)this.mockConnector);
        TestTransactedPollingMessageReceiver messageReceiver = new TestTransactedPollingMessageReceiver((Connector)this.mockConnector, this.mockFlowConstruct, this.mockEndpoint);
        messageReceiver.poll();
        ((MuleContext)Mockito.verify((Object)this.mockEndpoint.getMuleContext(), (VerificationMode)Mockito.timeout((long)1L))).handleException((Exception)Matchers.any(Exception.class));
    }

    @Test
    public void callSystemExceptionHandlerReceivingMessageInTransaction() throws Exception {
        Mockito.when((Object)this.mockEndpoint.getConnector()).thenReturn((Object)this.mockConnector);
        TestTransactedPollingMessageReceiver messageReceiver = new TestTransactedPollingMessageReceiver((Connector)this.mockConnector, this.mockFlowConstruct, this.mockEndpoint);
        messageReceiver.setReceiveMessagesInTransaction(true);
        messageReceiver.poll();
        ((MuleContext)Mockito.verify((Object)this.mockEndpoint.getMuleContext(), (VerificationMode)Mockito.timeout((long)1L))).handleException((Exception)Matchers.any(Exception.class));
    }

    @Test
    public void processCorrectlyWhenMessageResultsAreNull() throws Exception {
        Mockito.when((Object)this.mockEndpoint.getConnector()).thenReturn((Object)this.mockConnector);
        ((ExecutionTemplate)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Exception {
                Object[] args = invocation.getArguments();
                ExecutionCallback executionCallback = (ExecutionCallback)args[0];
                executionCallback.process();
                return null;
            }
        }).when(executionTemplate)).execute((ExecutionCallback)Matchers.any(ExecutionCallback.class));
        TestTransactedPollingProcessNullMessageReceiver messageReceiver = new TestTransactedPollingProcessNullMessageReceiver((Connector)this.mockConnector, this.mockFlowConstruct, this.mockEndpoint);
        messageReceiver.setReceiveMessagesInTransaction(true);
        messageReceiver.poll();
        ((MuleContext)Mockito.verify((Object)this.mockEndpoint.getMuleContext(), (VerificationMode)Mockito.never())).handleException((Exception)Matchers.any(Exception.class));
    }

    public static class TestTransactedPollingProcessNullMessageReceiver
    extends TransactedPollingMessageReceiver {
        public TestTransactedPollingProcessNullMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
            super(connector, flowConstruct, endpoint);
        }

        protected List<MuleMessage> getMessages() throws Exception {
            ArrayList<MuleMessage> messages = new ArrayList<MuleMessage>();
            messages.add(null);
            return messages;
        }

        protected MuleEvent processMessage(Object message) throws Exception {
            return null;
        }
    }

    public static class TestTransactedPollingMessageReceiver
    extends TransactedPollingMessageReceiver {
        public TestTransactedPollingMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
            super(connector, flowConstruct, endpoint);
        }

        protected List<MuleMessage> getMessages() throws Exception {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)"test exception"));
        }

        protected MuleEvent processMessage(Object message) throws Exception {
            return null;
        }
    }
}

