/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLClassLoader;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;

@SmallTest
public class IOUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    public void testLoadingResourcesAsStream() throws Exception {
        InputStream is = IOUtils.getResourceAsStream((String)"log4j2-test.xml", this.getClass(), (boolean)false, (boolean)false);
        Assert.assertNotNull((Object)is);
        is = IOUtils.getResourceAsStream((String)"does-not-exist.properties", this.getClass(), (boolean)false, (boolean)false);
        Assert.assertNull((Object)is);
    }

    @Test
    public void bufferSize() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[8192]);
        OutputStream out = (OutputStream)Mockito.mock(OutputStream.class);
        IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        ((OutputStream)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)2))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void increaseBufferSizeViaSystemProperty() throws Exception {
        int newBufferSize = 8192;
        MuleTestUtils.testWithSystemProperty("mule.streaming.bufferSize", Integer.toString(8192), new MuleTestUtils.TestCallback(){

            @Override
            public void run() throws Exception {
                ByteArrayInputStream in = new ByteArrayInputStream(new byte[8192]);
                OutputStream out = (OutputStream)Mockito.mock(OutputStream.class);
                Class clazz = ClassUtils.loadClass((String)IOUtils.class.getCanonicalName(), (ClassLoader)new URLClassLoader(((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs(), null));
                clazz.getMethod("copyLarge", InputStream.class, OutputStream.class).invoke(clazz.newInstance(), in, out);
                ((OutputStream)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)1))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
            }
        });
    }
}

