/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.ArrayUtils;
import org.mule.util.StringUtils;

@SmallTest
public class StringUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    public void testSplitAndTrim1() {
        Object[] result = StringUtils.splitAndTrim(null, (String)",,");
        Assert.assertNull((Object)result);
        result = StringUtils.splitAndTrim((String)"", (String)",");
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_STRING_ARRAY, result));
        result = StringUtils.splitAndTrim((String)" ", (String)",");
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_STRING_ARRAY, result));
    }

    @Test
    public void testSplitAndTrim2() {
        Object[] inputValues = new String[]{"foo", "bar", "baz", "kaboom"};
        String inputString = new StringBuilder(40).append(inputValues[0]).append(" ,").append(",  ").append(inputValues[1]).append(" ,").append(inputValues[2]).append("  ,  ").append(inputValues[3]).append(" ").toString();
        Assert.assertTrue((boolean)Arrays.equals(inputValues, StringUtils.splitAndTrim((String)inputString, (String)",")));
    }

    @Test
    public void testSplitAndTrim3() {
        Object[] inputValues = new String[]{"foo", "bar", "baz", "kaboom"};
        String inputString = "foo,  bar,\nbaz,  \nkaboom";
        Assert.assertTrue((boolean)Arrays.equals(inputValues, StringUtils.splitAndTrim((String)inputString, (String)",")));
    }

    @Test
    public void testHexStringToByteArray() {
        Assert.assertNull((Object)StringUtils.hexStringToByteArray(null));
        try {
            StringUtils.hexStringToByteArray((String)"1");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)Arrays.equals(new byte[0], StringUtils.hexStringToByteArray((String)"")));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1}, StringUtils.hexStringToByteArray((String)"01")));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 2}, StringUtils.hexStringToByteArray((String)"0102")));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{10, 14}, StringUtils.hexStringToByteArray((String)"0A0E")));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{10, 14}, StringUtils.hexStringToByteArray((String)"0a0e")));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{10, -1}, StringUtils.hexStringToByteArray((String)"0AFF")));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{10, -1}, StringUtils.hexStringToByteArray((String)"0aff")));
    }

    @Test
    public void testByteArrayToHexString() {
        Assert.assertNull((Object)StringUtils.toHexString(null));
        Assert.assertEquals((Object)"", (Object)StringUtils.toHexString((byte[])new byte[0]));
        Assert.assertEquals((Object)"01", (Object)StringUtils.toHexString((byte[])new byte[]{1}));
        Assert.assertEquals((Object)"0102", (Object)StringUtils.toHexString((byte[])new byte[]{1, 2}));
        Assert.assertEquals((Object)"0a0e", (Object)StringUtils.toHexString((byte[])new byte[]{10, 14}));
        Assert.assertEquals((Object)"0A0E", (Object)StringUtils.toHexString((byte[])new byte[]{10, 14}, (boolean)true));
        Assert.assertEquals((Object)"0aff", (Object)StringUtils.toHexString((byte[])new byte[]{10, -1}));
        Assert.assertEquals((Object)"0AFF", (Object)StringUtils.toHexString((byte[])new byte[]{10, -1}, (boolean)true));
    }

    @Test
    public void testMatch() {
        Pattern pattern = Pattern.compile("<<([\\w]*)>>");
        String value = "<<target>>";
        Assert.assertEquals((Object)StringUtils.match((Pattern)pattern, (String)value, (int)1), (Object)"target");
        try {
            StringUtils.match((Pattern)pattern, null, (int)1);
            Assert.fail((String)"was expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            StringUtils.match(null, (String)value, (int)1);
            Assert.fail((String)"was expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((Object)StringUtils.match((Pattern)pattern, (String)"hello world!", (int)1));
    }
}

