/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.concurrent;

import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.concurrent.WaitableBoolean;

public class WaitableBooleanTestCase
extends AbstractMuleTestCase {
    protected final WaitableBoolean TRUE = new WaitableBoolean(true);
    protected final WaitableBoolean FALSE = new WaitableBoolean(false);

    @Test
    public void testCompareToBoolean() {
        Assert.assertEquals((long)0L, (long)this.TRUE.compareTo(true));
        Assert.assertEquals((long)1L, (long)this.TRUE.compareTo(false));
        Assert.assertEquals((long)0L, (long)this.FALSE.compareTo(false));
        Assert.assertEquals((long)-1L, (long)this.FALSE.compareTo(true));
    }

    @Test
    public void testCompareToWaitableBoolean() {
        Assert.assertEquals((long)0L, (long)this.TRUE.compareTo(new WaitableBoolean(true)));
        Assert.assertEquals((long)1L, (long)this.TRUE.compareTo(new WaitableBoolean(false)));
        Assert.assertEquals((long)0L, (long)this.FALSE.compareTo(new WaitableBoolean(false)));
        Assert.assertEquals((long)-1L, (long)this.FALSE.compareTo(new WaitableBoolean(true)));
        Assert.assertEquals((long)0L, (long)this.TRUE.compareTo((Object)this.TRUE));
    }

    @Test
    public void testCompareToObject() {
        Assert.assertEquals((long)0L, (long)this.TRUE.compareTo((Object)this.TRUE));
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)this.TRUE.equals((Object)this.TRUE));
        Assert.assertFalse((boolean)this.TRUE.equals((Object)this.FALSE));
        Assert.assertFalse((boolean)this.FALSE.equals((Object)this.TRUE));
        Assert.assertTrue((boolean)this.TRUE.equals((Object)new WaitableBoolean(true)));
        Assert.assertTrue((boolean)this.FALSE.equals((Object)new WaitableBoolean(false)));
        Assert.assertFalse((boolean)this.TRUE.equals((Object)":-)"));
    }

    @Test
    public void testHashCode() {
        Assert.assertTrue((this.TRUE.hashCode() != this.FALSE.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((long)this.TRUE.hashCode(), (long)new WaitableBoolean(true).hashCode());
        Assert.assertEquals((long)this.FALSE.hashCode(), (long)new WaitableBoolean(false).hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"true", (Object)this.TRUE.toString());
        Assert.assertEquals((Object)"false", (Object)this.FALSE.toString());
    }

    @Test
    public void testGet() {
        Assert.assertTrue((boolean)this.TRUE.get());
        Assert.assertFalse((boolean)this.FALSE.get());
    }

    @Test
    public void testSet() {
        Assert.assertTrue((boolean)this.TRUE.set(true));
        Assert.assertTrue((boolean)this.TRUE.set(false));
        Assert.assertFalse((boolean)this.TRUE.set(true));
        Assert.assertFalse((boolean)this.FALSE.set(false));
        Assert.assertFalse((boolean)this.FALSE.set(true));
        Assert.assertTrue((boolean)this.FALSE.set(true));
    }

    @Test
    public void testCommit() {
        Assert.assertTrue((boolean)this.TRUE.compareAndSet(true, true));
        Assert.assertTrue((boolean)this.TRUE.get());
        Assert.assertFalse((boolean)this.TRUE.compareAndSet(false, true));
        Assert.assertTrue((boolean)this.TRUE.compareAndSet(true, false));
        Assert.assertFalse((boolean)this.TRUE.get());
        Assert.assertTrue((boolean)this.TRUE.compareAndSet(false, true));
        Assert.assertTrue((boolean)this.TRUE.get());
    }

    @Test
    public void testComplement() {
        Assert.assertFalse((boolean)this.TRUE.complement());
        Assert.assertFalse((boolean)this.TRUE.get());
        Assert.assertTrue((boolean)this.FALSE.complement());
        Assert.assertTrue((boolean)this.FALSE.get());
    }

    @Test
    public void testAnd() {
        Assert.assertTrue((boolean)new WaitableBoolean(true).and(true));
        Assert.assertFalse((boolean)new WaitableBoolean(true).and(false));
        Assert.assertFalse((boolean)new WaitableBoolean(false).and(false));
        Assert.assertFalse((boolean)new WaitableBoolean(false).and(true));
        Assert.assertTrue((boolean)this.TRUE.and(true));
        Assert.assertTrue((boolean)this.TRUE.get());
        Assert.assertFalse((boolean)this.TRUE.and(false));
        Assert.assertFalse((boolean)this.TRUE.get());
    }

    @Test
    public void testOr() {
        Assert.assertTrue((boolean)new WaitableBoolean(true).or(true));
        Assert.assertTrue((boolean)new WaitableBoolean(true).or(false));
        Assert.assertFalse((boolean)new WaitableBoolean(false).or(false));
        Assert.assertTrue((boolean)new WaitableBoolean(false).or(true));
        Assert.assertTrue((boolean)this.TRUE.or(true));
        Assert.assertTrue((boolean)this.TRUE.get());
        Assert.assertTrue((boolean)this.TRUE.or(false));
        Assert.assertTrue((boolean)this.TRUE.get());
    }

    @Test
    public void testXor() {
        Assert.assertFalse((boolean)new WaitableBoolean(true).xor(true));
        Assert.assertTrue((boolean)new WaitableBoolean(true).xor(false));
        Assert.assertFalse((boolean)new WaitableBoolean(false).xor(false));
        Assert.assertTrue((boolean)new WaitableBoolean(false).xor(true));
    }

    @Test
    public void testWhenFalse() throws InterruptedException {
        final WaitableBoolean blocker = new WaitableBoolean(true);
        final WaitableBoolean actionPerformed = new WaitableBoolean(false);
        Runnable switcher = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                    blocker.set(false);
                }
                catch (InterruptedException iex) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(iex);
                }
            }
        };
        Runnable action = new Runnable(){

            @Override
            public void run() {
                actionPerformed.set(true);
            }
        };
        new Thread(switcher).start();
        blocker.whenFalse(action);
        Assert.assertFalse((boolean)blocker.get());
        Assert.assertTrue((boolean)actionPerformed.get());
    }

    @Test
    public void testWhenFalseAlreadyFalse() throws InterruptedException {
        WaitableBoolean blocker = new WaitableBoolean(false);
        final WaitableBoolean actionPerformed = new WaitableBoolean(false);
        Runnable action = new Runnable(){

            @Override
            public void run() {
                actionPerformed.set(true);
            }
        };
        blocker.whenFalse(action);
        Assert.assertFalse((boolean)blocker.get());
        Assert.assertTrue((boolean)actionPerformed.get());
    }

    @Test
    public void testWhenTrue() throws InterruptedException {
        final WaitableBoolean blocker = new WaitableBoolean(false);
        final WaitableBoolean actionPerformed = new WaitableBoolean(false);
        Runnable switcher = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                    blocker.set(true);
                }
                catch (InterruptedException iex) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(iex);
                }
            }
        };
        Runnable action = new Runnable(){

            @Override
            public void run() {
                actionPerformed.set(true);
            }
        };
        new Thread(switcher).start();
        blocker.whenTrue(action);
        Assert.assertTrue((boolean)blocker.get());
        Assert.assertTrue((boolean)actionPerformed.get());
    }

    @Test
    public void testWhenTrueAlreadyTrue() throws InterruptedException {
        WaitableBoolean blocker = new WaitableBoolean(true);
        final WaitableBoolean actionPerformed = new WaitableBoolean(false);
        Runnable action = new Runnable(){

            @Override
            public void run() {
                actionPerformed.set(true);
            }
        };
        blocker.whenTrue(action);
        Assert.assertTrue((boolean)blocker.get());
        Assert.assertTrue((boolean)actionPerformed.get());
    }

    @Test
    public void testGetLock() {
        WaitableBoolean b = new WaitableBoolean(true);
        Assert.assertSame((Object)b, (Object)b.getLock());
        b = new WaitableBoolean(true, (Object)this);
        Assert.assertSame((Object)this, (Object)b.getLock());
    }
}

