/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.pool;

import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.object.ObjectFactory;
import org.mule.config.PoolingProfile;
import org.mule.tck.testmodels.fruit.BananaFactory;
import org.mule.util.pool.AbstractPoolingTestCase;
import org.mule.util.pool.CommonsPoolObjectPool;
import org.mule.util.pool.ObjectPool;

public class CommonsPoolObjectPoolTestCase
extends AbstractPoolingTestCase {
    @Test
    public void testPoolExhaustedFail() throws Exception {
        ObjectPool pool = this.createPoolWithExhaustedAction(0);
        Assert.assertEquals((long)0L, (long)pool.getNumActive());
        this.borrowObjectsUntilPoolIsFull(pool);
        try {
            pool.borrowObject();
            Assert.fail((String)"borrowing an object from a pool with policy WHEN_EXHAUSTED_FAIL must fail");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testPoolExhaustedGrow() throws Exception {
        ObjectPool pool = this.createPoolWithExhaustedAction(2);
        Assert.assertEquals((long)0L, (long)pool.getNumActive());
        this.borrowObjectsUntilPoolIsFull(pool);
        pool.borrowObject();
        Assert.assertEquals((long)4L, (long)pool.getNumActive());
    }

    @Test
    public void testPoolExhaustedWait() throws Exception {
        ObjectPool pool = this.createPoolWithExhaustedAction(1);
        Assert.assertEquals((long)0L, (long)pool.getNumActive());
        this.borrowObjectsUntilPoolIsFull(pool);
        long before = System.currentTimeMillis();
        try {
            pool.borrowObject();
            Assert.fail((String)"WHEN_EXHAUSTED_WAIT was specified but the pool returned an object");
        }
        catch (NoSuchElementException nse) {
            long delta = System.currentTimeMillis() - before;
            Assert.assertTrue((delta >= 1500L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testInitPoolNone() throws Exception {
        ObjectPool pool = this.createPoolWithInitialisationPolicy(0);
        CountingObjectFactory objectFactory = (CountingObjectFactory)pool.getObjectFactory();
        Assert.assertEquals((long)0L, (long)objectFactory.getInstanceCount());
    }

    @Test
    public void testInitPoolOne() throws Exception {
        ObjectPool pool = this.createPoolWithInitialisationPolicy(1);
        CountingObjectFactory objectFactory = (CountingObjectFactory)pool.getObjectFactory();
        Assert.assertEquals((long)1L, (long)objectFactory.getInstanceCount());
    }

    @Test
    public void testInitPoolAll() throws Exception {
        ObjectPool pool = this.createPoolWithInitialisationPolicy(2);
        CountingObjectFactory objectFactory = (CountingObjectFactory)pool.getObjectFactory();
        Assert.assertEquals((long)3L, (long)objectFactory.getInstanceCount());
    }

    private ObjectPool createPoolWithExhaustedAction(int exhaustedAction) throws Exception {
        PoolingProfile poolingProfile = this.createDefaultPoolingProfile();
        poolingProfile.setExhaustedAction(exhaustedAction);
        BananaFactory objectFactory = new BananaFactory();
        return this.createPool(poolingProfile, objectFactory);
    }

    private ObjectPool createPoolWithInitialisationPolicy(int initPolicy) throws Exception {
        PoolingProfile poolingProfile = this.createDefaultPoolingProfile();
        poolingProfile.setInitialisationPolicy(initPolicy);
        CountingObjectFactory objectFactory = new CountingObjectFactory();
        return this.createPool(poolingProfile, objectFactory);
    }

    private ObjectPool createPool(PoolingProfile poolingProfile, ObjectFactory objectFactory) throws Exception {
        CommonsPoolObjectPool pool = new CommonsPoolObjectPool(objectFactory, poolingProfile, muleContext);
        pool.initialise();
        return pool;
    }

    private void borrowObjectsUntilPoolIsFull(ObjectPool pool) throws Exception {
        for (int i = 1; i <= 3; ++i) {
            pool.borrowObject();
            Assert.assertEquals((long)i, (long)pool.getNumActive());
        }
    }

    private static class CountingObjectFactory
    extends BananaFactory {
        private int instanceCount = 0;

        private CountingObjectFactory() {
        }

        @Override
        public Object getInstance(MuleContext muleContext) throws Exception {
            ++this.instanceCount;
            return super.getInstance(muleContext);
        }

        public int getInstanceCount() {
            return this.instanceCount;
        }
    }
}

