/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.scan;

import java.util.Set;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.BloodOrange;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.OrangeInterface;
import org.mule.tck.testmodels.fruit.RedApple;
import org.mule.util.scan.ClasspathScanner;
import org.mule.util.scan.Grape;
import org.mule.util.scan.MadridOrange;
import org.mule.util.scan.SeedlessGrape;
import org.mule.util.scan.SubscribeBean;
import org.mule.util.scan.annotations.Marker;
import org.mule.util.scan.annotations.Meta;
import org.mule.util.scan.annotations.NonMeta;
import org.mule.util.scan.annotations.SampleBeanWithAnnotations;
import org.mule.util.scan.annotations.SampleClassWithAnnotations;

public class ClasspathScannerTestCase
extends AbstractMuleTestCase {
    @Test
    @Ignore(value="MULE-8260: ASM 3.3.1 is not working properly with Java 8")
    public void testSearchInterfaceScanClasspathAndJars() throws Exception {
        ClasspathScanner scanner = new ClasspathScanner(new String[]{"org"});
        Set set = scanner.scanFor(Fruit.class);
        Assert.assertTrue((boolean)set.contains(Apple.class));
        Assert.assertTrue((boolean)set.contains(RedApple.class));
        Assert.assertTrue((boolean)set.contains(BloodOrange.class));
        Assert.assertFalse((boolean)set.contains(OrangeInterface.class));
        Assert.assertTrue((boolean)set.contains(Orange.class));
        Assert.assertTrue((boolean)set.contains(Grape.class));
        Assert.assertTrue((boolean)set.contains(SeedlessGrape.class));
    }

    @Test
    @Ignore(value="MULE-8260: ASM 3.3.1 is not working properly with Java 8")
    public void testSearchInterfaceScanClasspathAndJarsWithInterfaceFlag() throws Exception {
        ClasspathScanner scanner = new ClasspathScanner(new String[]{"org/mule"});
        Set set = scanner.scanFor(Fruit.class, 2);
        Assert.assertTrue((boolean)set.contains(Apple.class));
        Assert.assertTrue((boolean)set.contains(RedApple.class));
        Assert.assertTrue((boolean)set.contains(BloodOrange.class));
        Assert.assertTrue((boolean)set.contains(OrangeInterface.class));
        Assert.assertTrue((boolean)set.contains(Orange.class));
        Assert.assertTrue((boolean)set.contains(Grape.class));
        Assert.assertTrue((boolean)set.contains(SeedlessGrape.class));
    }

    @Test
    @Ignore(value="MULE-8260: ASM 3.3.1 is not working properly with Java 8")
    public void testInterfaceScanClasspathAndJarsMultipleBasePaths() throws Exception {
        ClasspathScanner scanner = new ClasspathScanner(new String[]{"org/mule"});
        Set set = scanner.scanFor(Fruit.class);
        Assert.assertTrue((boolean)set.contains(Apple.class));
        Assert.assertTrue((boolean)set.contains(RedApple.class));
        Assert.assertTrue((boolean)set.contains(BloodOrange.class));
        Assert.assertFalse((boolean)set.contains(OrangeInterface.class));
        Assert.assertTrue((boolean)set.contains(Orange.class));
        Assert.assertTrue((boolean)set.contains(Grape.class));
        Assert.assertTrue((boolean)set.contains(SeedlessGrape.class));
        Assert.assertTrue((boolean)set.contains(MadridOrange.class));
    }

    @Test
    public void testImplementationScanClasspathAndJarsMultipleBasePaths() throws Exception {
        ClasspathScanner scanner = new ClasspathScanner(new String[]{"org/mule"});
        Set set = scanner.scanFor(Orange.class);
        Assert.assertFalse((boolean)set.contains(Apple.class));
        Assert.assertTrue((boolean)set.contains(BloodOrange.class));
        Assert.assertFalse((boolean)set.contains(OrangeInterface.class));
        Assert.assertFalse((boolean)set.contains(Orange.class));
        Assert.assertFalse((boolean)set.contains(Grape.class));
        Assert.assertTrue((boolean)set.contains(MadridOrange.class));
    }

    @Test
    public void testAnnotationMetaScanClasspathAndJarsMultipleBasePaths() throws Exception {
        ClasspathScanner scanner = new ClasspathScanner(new String[]{"org/mule/util"});
        Set set = scanner.scanFor(Meta.class);
        Assert.assertEquals((long)3L, (long)set.size());
        Assert.assertTrue((boolean)set.contains(SampleClassWithAnnotations.class));
        Assert.assertTrue((boolean)set.contains(SampleBeanWithAnnotations.class));
        Assert.assertTrue((boolean)set.contains(SubscribeBean.class));
    }

    @Test
    public void testAnnotationScanClasspathAndJarsMultipleBasePaths() throws Exception {
        ClasspathScanner scanner = new ClasspathScanner(new String[]{"org/mule"});
        Set set = scanner.scanFor(Marker.class);
        Assert.assertTrue((boolean)set.contains(SampleBeanWithAnnotations.class));
        Assert.assertTrue((boolean)set.contains(SubscribeBean.class));
        Set nonMetaSet = scanner.scanFor(NonMeta.class);
        Assert.assertTrue((boolean)nonMetaSet.contains(SampleBeanWithAnnotations.class));
    }
}

