/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.util.FileUtils;
import org.mule.util.store.TextFileObjectStore;

public class TextFileStoreTestCase
extends AbstractMuleContextTestCase {
    private static final int TTL = 3000;
    private static final int EXPIRY_INTERVAL = 1000;
    private static final int POLL_TIMEOUT = 5000;
    public static final String DIR = ".mule/temp";
    TextFileObjectStore store;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        FileUtils.deleteTree((File)new File(DIR));
    }

    @Override
    protected void doTearDown() throws Exception {
        if (this.store != null) {
            this.store.dispose();
        }
        FileUtils.deleteTree((File)new File(DIR));
        super.doTearDown();
    }

    @Test
    public void testTimedExpiryWhenLessThanMaxEntries() throws Exception {
        this.createObjectStore("timed", 3000, 1000);
        this.storeObjects("1");
        this.assertObjectsInStore("timed.dat", "1");
        new PollingProber(5000L, 500L).check(new JUnitProbe(){

            @Override
            protected boolean test() throws Exception {
                TextFileStoreTestCase.this.assertObjectsExpired("timed.dat", new String[]{"1"});
                return true;
            }
        });
    }

    @Test
    public void testTimedExpiry() throws Exception {
        this.createObjectStore("timed", 3000, 1000);
        this.storeObjects("1", "2", "3");
        this.assertObjectsInStore("timed.dat", "1", "2", "3");
        new PollingProber(5000L, 500L).check(new JUnitProbe(){

            @Override
            protected boolean test() throws Exception {
                TextFileStoreTestCase.this.assertObjectsExpired("timed.dat", new String[]{"1", "2", "3"});
                return true;
            }
        });
    }

    @Test
    public void testTimedExpiryWithRestart() throws Exception {
        this.createObjectStore("timed", 3000, 1000);
        this.storeObjects("1", "2", "3");
        this.assertObjectsInStore("timed.dat", "1", "2", "3");
        this.store.dispose();
        this.createObjectStore("timed", 3000, 1000);
        this.assertObjectsInStore("timed.dat", "1", "2", "3");
        new PollingProber(5000L, 500L).check(new JUnitProbe(){

            @Override
            protected boolean test() throws Exception {
                TextFileStoreTestCase.this.assertObjectsExpired("timed.dat", new String[]{"1", "2", "3"});
                return true;
            }
        });
        this.store.dispose();
        this.createObjectStore("timed", 3000, 1000);
        this.assertObjectsExpired("timed.dat", "1", "2", "3");
    }

    @Test
    public void testTimedExpiryWithObjects() throws Exception {
        this.createObjectStore("timed", 3000, 1000);
    }

    @Test
    public void testMaxSize() throws Exception {
        this.createObjectStore("bounded", -1, 1000);
        this.storeObjects("1", "2", "3");
        this.assertObjectsInStore("bounded.dat", "1", "2", "3");
        new PollingProber(5000L, 500L).check(new JUnitProbe(){

            @Override
            protected boolean test() throws Exception {
                TextFileStoreTestCase.this.assertObjectsInStore("bounded.dat", new String[]{"1", "2", "3"});
                return true;
            }
        });
        this.storeObjects("4");
        this.store.expire();
        this.assertObjectsExpired("bounded.dat", "1");
        this.assertObjectsInStore("bounded.dat", "2", "3", "4");
        this.storeObjects("5");
        this.store.expire();
        this.assertObjectsExpired("bounded.dat", "2");
        this.assertObjectsInStore("bounded.dat", "3", "4", "5");
        this.storeObjects("6", "7", "8", "9");
        this.store.expire();
        this.assertObjectsExpired("bounded.dat", "3", "4", "5");
        this.assertObjectsInStore("bounded.dat", "7", "8", "9");
    }

    private void assertObjectsExpired(String file, String ... identifiers) throws Exception {
        Properties props = new Properties();
        props.load(new FileInputStream(new File(".mule/temp/" + file)));
        for (String id : identifiers) {
            MatcherAssert.assertThat((Object)this.store.contains((Serializable)((Object)id)), (Matcher)CoreMatchers.equalTo((Object)false));
            MatcherAssert.assertThat(props.values(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)id)));
        }
    }

    private void assertObjectsInStore(String file, String ... identifiers) throws Exception {
        Properties props = new Properties();
        props.load(new FileInputStream(new File(".mule/temp/" + file)));
        for (String id : identifiers) {
            MatcherAssert.assertThat((Object)this.store.contains((Serializable)((Object)id)), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat(props.values(), (Matcher)CoreMatchers.hasItem((Object)id));
        }
    }

    private void storeObjects(String ... objects) throws Exception {
        for (String entry : objects) {
            this.store.store((Serializable)((Object)entry), entry);
        }
    }

    private void createObjectStore(String fileName, int ttl, int expirationInterval) throws InitialisationException {
        this.store = new TextFileObjectStore();
        this.store.setDirectory(DIR);
        this.store.setMuleContext(muleContext);
        this.store.setName(fileName);
        this.store.setMaxEntries(3);
        this.store.setEntryTTL(ttl);
        this.store.setExpirationInterval(expirationInterval);
        this.store.initialise();
    }
}

