/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.exception;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;

public class MessageRedeliveredException
extends MessagingException {
    private static final long serialVersionUID = 9013890402770563931L;
    private static final Message REDELIVERED_FAILURE_MESSAGE = CoreMessages.createStaticMessage("Maximum redelivery attempts reached");
    private final transient ImmutableEndpoint endpoint;
    private String messageId;
    private int redeliveryCount;
    private int maxRedelivery;

    public MessageRedeliveredException(String messageId, int redeliveryCount, int maxRedelivery, InboundEndpoint endpoint, MuleEvent event) {
        this(messageId, redeliveryCount, maxRedelivery, endpoint, event, REDELIVERED_FAILURE_MESSAGE);
    }

    public MessageRedeliveredException(String messageId, int redeliveryCount, int maxRedelivery, InboundEndpoint endpoint, MuleEvent event, Message message) {
        super(message, event);
        this.messageId = messageId;
        this.redeliveryCount = redeliveryCount;
        this.maxRedelivery = maxRedelivery;
        this.endpoint = endpoint;
    }

    public MessageRedeliveredException(String messageId, int redeliveryCount, int maxRedelivery, InboundEndpoint endpoint, MuleEvent event, Message message, MessageProcessor failingMessageProcessor) {
        super(message, event, failingMessageProcessor);
        this.messageId = messageId;
        this.redeliveryCount = redeliveryCount;
        this.maxRedelivery = maxRedelivery;
        this.endpoint = endpoint;
    }

    public MessageRedeliveredException(String messageId, int redeliveryCount, int maxRedelivery, InboundEndpoint endpoint, MuleEvent event, MessageProcessor failingMessageProcessor) {
        this(messageId, redeliveryCount, maxRedelivery, endpoint, event, REDELIVERED_FAILURE_MESSAGE, failingMessageProcessor);
    }

    public String getMessageId() {
        return this.messageId;
    }

    public int getRedeliveryCount() {
        return this.redeliveryCount;
    }

    public int getMaxRedelivery() {
        return this.maxRedelivery;
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }
}

