/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.execution;

import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.api.AnnotatedObject;
import org.mule.api.execution.ExceptionContextProvider;
import org.mule.api.util.CredentialsMaskUtil;

public abstract class LocationExecutionContextProvider
implements ExceptionContextProvider {
    private static final QName NAME_ANNOTATION_KEY = new QName("http://www.mulesoft.org/schema/mule/documentation", "name");
    private static final QName SOURCE_FILE_ANNOTATION_KEY = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileName");
    private static final QName SOURCE_FILE_LINE_ANNOTATION_KEY = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileLine");
    static final QName SOURCE_ELEMENT_ANNOTATION_KEY = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceElement");

    public static void addMetadataAnnotationsFromXml(Map<QName, Object> beanAnnotations, String fileName, int lineNumber, String xmlContent) {
        beanAnnotations.put(SOURCE_FILE_ANNOTATION_KEY, fileName);
        beanAnnotations.put(SOURCE_FILE_LINE_ANNOTATION_KEY, lineNumber);
        beanAnnotations.put(SOURCE_ELEMENT_ANNOTATION_KEY, xmlContent);
    }

    public static String resolveProcessorRepresentation(String appId, String processorPath, Object element) {
        String docName = LocationExecutionContextProvider.getDocName(element);
        if (docName != null) {
            return String.format("%s @ %s:%s:%d (%s)", processorPath, appId, LocationExecutionContextProvider.getSourceFile((AnnotatedObject)element), LocationExecutionContextProvider.getSourceFileLine((AnnotatedObject)element), docName);
        }
        if (element instanceof AnnotatedObject) {
            return String.format("%s @ %s:%s:%d", processorPath, appId, LocationExecutionContextProvider.getSourceFile((AnnotatedObject)element), LocationExecutionContextProvider.getSourceFileLine((AnnotatedObject)element));
        }
        return String.format("%s @ %s", processorPath, appId);
    }

    public static String getDocName(Object element) {
        if (element instanceof AnnotatedObject) {
            Object docName = ((AnnotatedObject)element).getAnnotation(NAME_ANNOTATION_KEY);
            return docName != null ? docName.toString() : null;
        }
        return null;
    }

    protected static String getSourceFile(AnnotatedObject element) {
        return (String)element.getAnnotation(SOURCE_FILE_ANNOTATION_KEY);
    }

    protected static Integer getSourceFileLine(AnnotatedObject element) {
        return (Integer)element.getAnnotation(SOURCE_FILE_LINE_ANNOTATION_KEY);
    }

    protected static String getSourceXML(AnnotatedObject element) {
        Object sourceXml = element.getAnnotation(SOURCE_ELEMENT_ANNOTATION_KEY);
        return sourceXml != null ? CredentialsMaskUtil.maskPasswords(sourceXml.toString()) : null;
    }
}

