/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.api.context.notification.BlockingServerEvent;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.context.notification.Configuration;
import org.mule.context.notification.ListenerSubscriptionPair;
import org.mule.context.notification.Policy;
import org.mule.util.ClassUtils;

public class ServerNotificationManager
implements Work,
Disposable,
ServerNotificationHandler,
MuleContextAware {
    public static final String NULL_SUBSCRIPTION = "NULL";
    protected Log logger = LogFactory.getLog(this.getClass());
    private boolean dynamic = false;
    private Configuration configuration = new Configuration();
    private AtomicBoolean disposed = new AtomicBoolean(false);
    private volatile Thread runningThread;
    private BlockingDeque<ServerNotification> eventQueue = new LinkedBlockingDeque<ServerNotification>();
    private MuleContext muleContext;

    @Override
    public boolean isNotificationDynamic() {
        return this.dynamic;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setNotificationDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void start(WorkManager workManager, WorkListener workListener) throws LifecycleException {
        try {
            workManager.scheduleWork(this, Long.MAX_VALUE, null, workListener);
        }
        catch (WorkException e) {
            throw new LifecycleException(e, (Object)this);
        }
    }

    public void addInterfaceToType(Class<? extends ServerNotificationListener> iface, Class<? extends ServerNotification> event) {
        this.configuration.addInterfaceToType(iface, event);
    }

    public void setInterfaceToTypes(Map<Class<? extends ServerNotificationListener>, Set<Class<? extends ServerNotification>>> interfaceToEvents) throws ClassNotFoundException {
        this.configuration.addAllInterfaceToTypes(interfaceToEvents);
    }

    public void addListenerSubscriptionPair(ListenerSubscriptionPair pair) {
        this.configuration.addListenerSubscriptionPair(pair);
    }

    public void addListener(ServerNotificationListener<?> listener) {
        this.configuration.addListenerSubscriptionPair(new ListenerSubscriptionPair(listener));
    }

    public void addListenerSubscription(ServerNotificationListener<?> listener, String subscription) {
        this.configuration.addListenerSubscriptionPair(new ListenerSubscriptionPair(listener, subscription));
    }

    @Deprecated
    public void addAllListenerSubscriptionPairs(Collection<?> pairs) {
        this.configuration.addAllListenerSubscriptionPairs(pairs);
    }

    @Deprecated
    public void setAllListenerSubscriptionPairs(Collection<?> pairs) {
        this.configuration.addAllListenerSubscriptionPairs(pairs);
    }

    public void removeListener(ServerNotificationListener<?> listener) {
        this.configuration.removeListener(listener);
    }

    @Deprecated
    public void removeAllListeners(Collection<ServerNotificationListener> listeners) {
        this.configuration.removeAllListeners(listeners);
    }

    public void disableInterface(Class<? extends ServerNotificationListener> iface) throws ClassNotFoundException {
        this.configuration.disableInterface(iface);
    }

    public void setDisabledInterfaces(Collection<Class<? extends ServerNotificationListener>> interfaces) throws ClassNotFoundException {
        this.configuration.disabledAllInterfaces(interfaces);
    }

    public void disableType(Class<? extends ServerNotification> type) throws ClassNotFoundException {
        this.configuration.disableType(type);
    }

    @Deprecated
    public void setDisabledTypes(Collection<Class<? extends ServerNotificationListener>> types) throws ClassNotFoundException {
        this.configuration.disableAllTypes(types);
    }

    @Override
    public boolean isListenerRegistered(ServerNotificationListener listener) {
        for (ListenerSubscriptionPair pair : this.configuration.getListeners()) {
            if (!pair.getListener().equals(listener)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fireNotification(ServerNotification notification) {
        if (!this.disposed.get()) {
            notification.setMuleContext(this.muleContext);
            if (notification instanceof BlockingServerEvent) {
                this.notifyListeners(notification);
                return;
            } else {
                try {
                    this.eventQueue.put(notification);
                    return;
                }
                catch (InterruptedException e) {
                    if (this.disposed.get()) return;
                    this.logger.error((Object)("Failed to queue notification: " + notification), (Throwable)e);
                }
            }
            return;
        } else {
            this.logger.warn((Object)("Notification not enqueued after ServerNotificationManager disposal: " + notification));
        }
    }

    @Override
    public boolean isNotificationEnabled(Class<? extends ServerNotification> type) {
        Policy policy;
        boolean enabled = false;
        if (this.configuration != null && (policy = this.configuration.getPolicy()) != null) {
            enabled = policy.isNotificationEnabled(type);
        }
        return enabled;
    }

    @Override
    public void dispose() {
        this.disposed.set(true);
        this.configuration = null;
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
    }

    protected void notifyListeners(ServerNotification notification) {
        if (!this.disposed.get()) {
            this.configuration.getPolicy().dispatch(notification);
        } else {
            this.logger.warn((Object)("Notification not delivered after ServerNotificationManager disposal: " + notification));
        }
    }

    public void release() {
        this.dispose();
    }

    public void run() {
        this.runningThread = Thread.currentThread();
        while (!this.disposed.get()) {
            try {
                int timeout = this.muleContext.getConfiguration().getDefaultQueueTimeout();
                ServerNotification notification = this.eventQueue.poll(timeout, TimeUnit.MILLISECONDS);
                if (notification == null) continue;
                this.notifyListeners(notification);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Deprecated
    public Queue<ServerNotification> getEventQueue() {
        return this.eventQueue;
    }

    static Class toClass(Object value) throws ClassNotFoundException {
        Class clazz;
        if (value instanceof String) {
            clazz = ClassUtils.loadClass(value.toString(), value.getClass());
        } else if (value instanceof Class) {
            clazz = (Class)value;
        } else {
            throw new IllegalArgumentException("Notification types and listeners must be a Class with fully qualified class name. Value is: " + value);
        }
        return clazz;
    }

    Policy getPolicy() {
        return this.configuration.getPolicy();
    }

    public Map<Class<? extends ServerNotificationListener>, Set<Class<? extends ServerNotification>>> getInterfaceToTypes() {
        return Collections.unmodifiableMap(this.configuration.getInterfaceToTypes());
    }

    public Set<ListenerSubscriptionPair> getListeners() {
        return Collections.unmodifiableSet(this.configuration.getListeners());
    }
}

