/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.management.stats.ProcessingTime;
import org.mule.management.stats.ProcessingTimeWatcher;
import org.mule.util.concurrent.ThreadNameHelper;

public class DefaultProcessingTimeWatcher
implements ProcessingTimeWatcher,
MuleContextAware {
    private static final Log logger = LogFactory.getLog(DefaultProcessingTimeWatcher.class);
    private final ReferenceQueue<ProcessingTime> queue = new ReferenceQueue();
    private final Map<ProcessingTimeReference, Object> refs = new ConcurrentHashMap<ProcessingTimeReference, Object>();
    private Thread watcherThread;
    private MuleContext muleContext;

    @Override
    public void addProcessingTime(ProcessingTime processingTime) {
        this.refs.put(new ProcessingTimeReference(processingTime, this.queue), this.refs);
    }

    @Override
    public void start() throws MuleException {
        String threadName = String.format("%sprocessing.time.monitor", ThreadNameHelper.getPrefix(this.muleContext));
        this.watcherThread = new Thread((Runnable)new ProcessingTimeChecker(), threadName);
        this.watcherThread.setDaemon(true);
        this.watcherThread.start();
    }

    @Override
    public void stop() throws MuleException {
        if (this.watcherThread != null) {
            this.watcherThread.interrupt();
        }
        this.refs.clear();
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    static class ProcessingTimeReference
    extends WeakReference<ProcessingTime> {
        private FlowConstructStatistics statistics;
        private AtomicLong accumulator;

        ProcessingTimeReference(ProcessingTime time, ReferenceQueue<ProcessingTime> queue) {
            super(time, queue);
            this.statistics = time.getStatistics();
            this.accumulator = time.getAccumulator();
        }

        public AtomicLong getAccumulator() {
            return this.accumulator;
        }

        public FlowConstructStatistics getStatistics() {
            return this.statistics;
        }
    }

    private class ProcessingTimeChecker
    implements Runnable {
        private ProcessingTimeChecker() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    ProcessingTimeReference ref = (ProcessingTimeReference)DefaultProcessingTimeWatcher.this.queue.remove();
                    DefaultProcessingTimeWatcher.this.refs.remove(ref);
                    FlowConstructStatistics stats = ref.getStatistics();
                    if (!stats.isEnabled()) continue;
                    stats.addCompleteFlowExecutionTime(ref.getAccumulator().longValue());
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception ex) {
                    logger.error((Object)this, (Throwable)ex);
                }
            }
        }
    }
}

