/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.compression;

import java.io.IOException;
import java.io.InputStream;
import org.mule.api.serialization.SerializationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.transformer.compression.AbstractCompressionTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.compression.GZipCompression;

public class GZipUncompressTransformer
extends AbstractCompressionTransformer {
    public GZipUncompressTransformer() {
        this.setStrategy(new GZipCompression());
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.setReturnDataType(DataTypeFactory.OBJECT);
    }

    @Override
    public Object doTransform(Object src, String outputEncoding) throws TransformerException {
        try {
            if (src instanceof InputStream) {
                return this.getStrategy().uncompressInputStream((InputStream)src);
            }
            byte[] buffer = this.getStrategy().uncompressByteArray((byte[])src);
            DataType<?> returnDataType = this.getReturnDataType();
            if (DataTypeFactory.STRING.equals(returnDataType)) {
                return new String(buffer, outputEncoding);
            }
            if (!DataTypeFactory.OBJECT.equals(returnDataType) && !DataTypeFactory.BYTE_ARRAY.equals(returnDataType)) {
                try {
                    return this.muleContext.getObjectSerializer().deserialize(buffer);
                }
                catch (SerializationException e) {
                    throw new TransformerException(this, (Throwable)e);
                }
            }
            try {
                return this.muleContext.getObjectSerializer().deserialize(buffer);
            }
            catch (SerializationException e) {
                return buffer;
            }
        }
        catch (IOException e) {
            throw new TransformerException(MessageFactory.createStaticMessage("Failed to uncompress message."), this, (Throwable)e);
        }
    }
}

