/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.AttributeEvaluator;
import org.mule.util.WildcardAttributeEvaluator;

public class CopyPropertiesTransformer
extends AbstractMessageTransformer {
    private AttributeEvaluator propertyNameEvaluator;
    private WildcardAttributeEvaluator wildcardPropertyNameEvaluator;

    public CopyPropertiesTransformer() {
        this.registerSourceType(DataTypeFactory.OBJECT);
        this.setReturnDataType(DataTypeFactory.OBJECT);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.propertyNameEvaluator.initialize(this.muleContext.getExpressionManager());
    }

    @Override
    public Object transformMessage(final MuleMessage message, String outputEncoding) throws TransformerException {
        if (this.wildcardPropertyNameEvaluator.hasWildcards()) {
            this.wildcardPropertyNameEvaluator.processValues(message.getInboundPropertyNames(), new WildcardAttributeEvaluator.MatchCallback(){

                @Override
                public void processMatch(String matchedValue) {
                    message.setOutboundProperty(matchedValue, message.getInboundProperty(matchedValue), message.getPropertyDataType(matchedValue, PropertyScope.INBOUND));
                }
            });
        } else {
            Object keyValue = this.propertyNameEvaluator.resolveValue(message);
            if (keyValue != null) {
                String propertyName = keyValue.toString();
                Object propertyValue = message.getInboundProperty(propertyName);
                if (propertyValue != null) {
                    message.setOutboundProperty(propertyName, propertyValue, message.getPropertyDataType(propertyName, PropertyScope.INBOUND));
                } else {
                    this.logger.info((Object)"Property value for is null, no property will be copied");
                }
            } else {
                this.logger.info((Object)"Key expression return null, no property will be copied");
            }
        }
        return message;
    }

    public Object clone() throws CloneNotSupportedException {
        CopyPropertiesTransformer clone = (CopyPropertiesTransformer)super.clone();
        clone.setPropertyName(this.propertyNameEvaluator.getRawValue());
        return clone;
    }

    public void setPropertyName(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Null propertyName not supported");
        }
        this.propertyNameEvaluator = new AttributeEvaluator(propertyName);
        this.wildcardPropertyNameEvaluator = new WildcardAttributeEvaluator(propertyName);
    }
}

