/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import org.mule.AbstractAnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.DataType;
import org.mule.transformer.types.SimpleDataType;
import org.mule.transformer.types.TypedValue;
import org.mule.transport.NullPayload;
import org.mule.util.AttributeEvaluator;
import org.mule.util.StringUtils;

public class SetPayloadMessageProcessor
extends AbstractAnnotatedObject
implements MessageProcessor,
MuleContextAware,
Initialisable {
    private String mimeType;
    private String encoding;
    private AttributeEvaluator valueEvaluator = new AttributeEvaluator(null);
    private MuleContext muleContext;

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (StringUtils.isEmpty((String)this.mimeType) && StringUtils.isEmpty((String)this.encoding)) {
            TypedValue typedValue = this.resolveTypedValue(event);
            event.getMessage().setPayload(typedValue.getValue(), typedValue.getDataType());
        } else {
            Object value = this.resolveValue(event);
            DataType dataType = this.resolveDataType(event, value);
            event.getMessage().setPayload(value, dataType);
        }
        return event;
    }

    private Object resolveValue(MuleEvent event) {
        Object value = this.valueEvaluator.getRawValue() == null ? NullPayload.getInstance() : this.valueEvaluator.resolveValue(event.getMessage());
        return value;
    }

    private TypedValue resolveTypedValue(MuleEvent event) {
        if (this.valueEvaluator.getRawValue() == null) {
            return new TypedValue(NullPayload.getInstance(), DataType.OBJECT_DATA_TYPE);
        }
        return this.valueEvaluator.resolveTypedValue(event.getMessage());
    }

    private DataType resolveDataType(MuleEvent event, Object value) {
        Class<Object> type = value == null || value instanceof NullPayload ? Object.class : value.getClass();
        SimpleDataType simpleDataType = new SimpleDataType(type, this.mimeType);
        simpleDataType.setEncoding(this.encoding);
        return simpleDataType;
    }

    @Deprecated
    public void setName(String name) {
    }

    @Deprecated
    public void setIgnoreBadInput(boolean ignoreBadInput) {
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setReturnClass(String className) {
    }

    public void setValue(String value) {
        this.valueEvaluator = new AttributeEvaluator(value);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void initialise() throws InitialisationException {
        this.valueEvaluator.initialize(this.muleContext.getExpressionManager());
    }
}

