/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.List;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.mule.DefaultMuleEvent;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.CompletionHandler;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageDispatcher;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.Flow;
import org.mule.service.ServiceAsyncReplyCompositeMessageSource;
import org.mule.transport.AbstractTransportMessageHandler;
import org.mule.transport.ConnectableLifecycleManager;

public abstract class AbstractMessageDispatcher
extends AbstractTransportMessageHandler
implements MessageDispatcher {
    protected List<Transformer> defaultOutboundTransformers;
    protected List<Transformer> defaultResponseTransformers;

    public AbstractMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
    }

    protected ConnectableLifecycleManager createLifecycleManager() {
        this.defaultOutboundTransformers = this.connector.getDefaultOutboundTransformers(this.endpoint);
        this.defaultResponseTransformers = this.connector.getDefaultResponseTransformers(this.endpoint);
        return new ConnectableLifecycleManager<AbstractMessageDispatcher>(this.getDispatcherName(), this);
    }

    protected String getDispatcherName() {
        return this.getConnector().getName() + ".dispatcher." + System.identityHashCode(this);
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        try {
            boolean disableTransportTransformer;
            this.connect();
            String prop = (String)event.getMessage().getOutboundProperty("MULE_DISABLE_TRANSPORT_TRANSFORMER");
            boolean bl = disableTransportTransformer = prop != null && Boolean.parseBoolean(prop) || this.endpoint.isDisableTransportTransformer();
            if (!disableTransportTransformer) {
                this.applyOutboundTransformers(event);
            }
            boolean hasResponse = this.endpoint.getExchangePattern().hasResponse();
            this.connector.getSessionHandler().storeSessionInfoToMessage(event.getSession(), event.getMessage());
            if (hasResponse) {
                if (!event.getMuleContext().waitUntilStarted(event.getTimeout())) {
                    throw new MessagingException(MessageFactory.createStaticMessage("Timeout waiting for mule context to be completely started"), event, (MessageProcessor)this);
                }
                if (this.isNonBlocking(event)) {
                    this.doSendNonBlocking(event, new NonBlockingSendCompletionHandler(event, ((Flow)event.getFlowConstruct()).getWorkManager(), this.connector));
                    RequestContext.clear();
                    return NonBlockingVoidMuleEvent.getInstance();
                }
                MuleMessage resultMessage = this.doSend(event);
                return this.createResponseEvent(resultMessage, event);
            }
            this.doDispatch(event);
            return VoidMuleEvent.getInstance();
        }
        catch (MuleException muleException) {
            throw muleException;
        }
        catch (Exception e) {
            throw new DispatchException(event, this.getEndpoint(), (Throwable)e);
        }
    }

    private MuleEvent createResponseEvent(MuleMessage resultMessage, MuleEvent requestEvent) throws MuleException {
        if (resultMessage != null) {
            resultMessage.setMessageRootId(requestEvent.getMessage().getMessageRootId());
            resultMessage.setEncoding(resultMessage.getEncoding());
            MuleSession storedSession = this.connector.getSessionHandler().retrieveSessionInfoFromMessage(resultMessage);
            requestEvent.getSession().merge(storedSession);
            DefaultMuleEvent resultEvent = new DefaultMuleEvent(resultMessage, requestEvent);
            OptimizedRequestContext.unsafeSetEvent(resultEvent);
            return resultEvent;
        }
        return null;
    }

    private boolean isNonBlocking(MuleEvent event) {
        return event.getFlowConstruct() instanceof Flow && event.isAllowNonBlocking() && event.getReplyToHandler() != null && this.isSupportsNonBlocking() && !this.endpoint.getTransactionConfig().isTransacted();
    }

    protected boolean isSupportsNonBlocking() {
        return false;
    }

    @Deprecated
    protected boolean returnResponse(MuleEvent event) {
        return this.returnResponse(event, false);
    }

    protected boolean returnResponse(MuleEvent event, boolean doSend) {
        boolean remoteSync = false;
        if (this.endpoint.getConnector().isResponseEnabled()) {
            boolean hasResponse = this.endpoint.getExchangePattern().hasResponse();
            boolean bl = remoteSync = hasResponse || doSend;
            if (remoteSync && event.getFlowConstruct() != null && event.getFlowConstruct() instanceof Service) {
                ServiceAsyncReplyCompositeMessageSource responseRouters = ((Service)event.getFlowConstruct()).getAsyncReplyMessageSource();
                remoteSync = responseRouters == null || responseRouters.getEndpoints().size() <= 0;
            }
        }
        if (!remoteSync) {
            event.getMessage().removeProperty("MULE_REMOTE_SYNC");
        }
        return remoteSync;
    }

    @Override
    protected WorkManager getWorkManager() {
        try {
            return this.connector.getDispatcherWorkManager();
        }
        catch (MuleException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public OutboundEndpoint getEndpoint() {
        return (OutboundEndpoint)super.getEndpoint();
    }

    protected void applyOutboundTransformers(MuleEvent event) throws MuleException {
        event.getMessage().applyTransformers(event, this.defaultOutboundTransformers);
    }

    protected void applyResponseTransformers(MuleEvent event) throws MuleException {
        event.getMessage().applyTransformers(event, this.defaultResponseTransformers);
    }

    protected abstract void doDispatch(MuleEvent var1) throws Exception;

    protected abstract MuleMessage doSend(MuleEvent var1) throws Exception;

    protected void doSendNonBlocking(MuleEvent event, CompletionHandler<MuleMessage, Exception> completionHandler) {
        throw new IllegalStateException("This MessageDispatcher does not support non-blocking");
    }

    private class NonBlockingSendCompletionHandler
    implements CompletionHandler<MuleMessage, Exception> {
        private final MuleEvent event;
        private final WorkManager workManager;
        private final WorkListener workListener;

        public NonBlockingSendCompletionHandler(MuleEvent event, WorkManager workManager, WorkListener workListener) {
            this.event = event;
            this.workManager = workManager;
            this.workListener = workListener;
        }

        @Override
        public void onCompletion(final MuleMessage result) {
            try {
                this.workManager.scheduleWork(new Work(){

                    public void run() {
                        try {
                            NonBlockingSendCompletionHandler.this.resetAccessControl(result);
                            MuleEvent responseEvent = AbstractMessageDispatcher.this.createResponseEvent(result, NonBlockingSendCompletionHandler.this.event);
                            OptimizedRequestContext.unsafeSetEvent(responseEvent);
                            NonBlockingSendCompletionHandler.this.event.getReplyToHandler().processReplyTo(responseEvent, null, null);
                        }
                        catch (MessagingException messagingException) {
                            NonBlockingSendCompletionHandler.this.event.getReplyToHandler().processExceptionReplyTo(messagingException, null);
                        }
                        catch (MuleException exception) {
                            NonBlockingSendCompletionHandler.this.event.getReplyToHandler().processExceptionReplyTo(new MessagingException(NonBlockingSendCompletionHandler.this.event, (Throwable)exception), null);
                        }
                    }

                    public void release() {
                    }
                }, Long.MAX_VALUE, null, this.workListener);
            }
            catch (Exception exception) {
                this.onFailure(exception);
            }
        }

        @Override
        public void onFailure(final Exception exception) {
            try {
                this.workManager.scheduleWork(new Work(){

                    public void run() {
                        NonBlockingSendCompletionHandler.this.resetAccessControl(NonBlockingSendCompletionHandler.this.event);
                        OptimizedRequestContext.unsafeSetEvent(NonBlockingSendCompletionHandler.this.event);
                        NonBlockingSendCompletionHandler.this.event.getReplyToHandler().processExceptionReplyTo(new MessagingException(NonBlockingSendCompletionHandler.this.event, (Throwable)exception), null);
                    }

                    public void release() {
                    }
                }, Long.MAX_VALUE, null, this.workListener);
            }
            catch (WorkException e) {
                this.event.getReplyToHandler().processExceptionReplyTo(new MessagingException(this.event, (Throwable)exception), null);
            }
        }

        private void resetAccessControl(Object result) {
            if (result instanceof ThreadSafeAccess) {
                ((ThreadSafeAccess)result).resetAccessControl();
            }
        }
    }
}

