/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.polling.schedule;

import java.util.concurrent.TimeUnit;
import org.mule.api.schedule.Scheduler;
import org.mule.api.schedule.SchedulerFactory;
import org.mule.transport.polling.schedule.FixedFrequencyScheduler;
import org.mule.util.Preconditions;

public class FixedFrequencySchedulerFactory<T extends Runnable>
extends SchedulerFactory<T> {
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private long frequency = 1000L;
    private long startDelay = 1000L;

    @Override
    protected Scheduler doCreate(String name, T job) {
        FixedFrequencyScheduler<T> fixedFrequencyScheduler = new FixedFrequencyScheduler<T>(name, this.frequency, this.startDelay, job, this.timeUnit);
        return fixedFrequencyScheduler;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setFrequency(long frequency) {
        Preconditions.checkArgument(frequency > 0L, "Frequency must be greater then zero");
        this.frequency = frequency;
    }

    public void setStartDelay(long startDelay) {
        Preconditions.checkArgument(startDelay >= 0L, "Start delay must be greater then zero");
        this.startDelay = startDelay;
    }
}

