/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import org.mule.api.MuleContext;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueProvider;
import org.mule.util.queue.QueueSession;
import org.mule.util.queue.QueueStore;
import org.mule.util.queue.QueueTransactionContext;
import org.mule.util.queue.TransactionAwareQueueStore;
import org.mule.util.queue.TransactionContextProvider;

public abstract class AbstractQueueSession
implements QueueSession {
    private final QueueProvider queueProvider;
    private final MuleContext muleContext;

    public AbstractQueueSession(QueueProvider queueProvider, MuleContext muleContext) {
        this.queueProvider = queueProvider;
        this.muleContext = muleContext;
    }

    @Override
    public Queue getQueue(String name) {
        QueueStore queueStore = this.queueProvider.getQueue(name);
        return new TransactionAwareQueueStore(queueStore, new TransactionContextProvider(){

            @Override
            public boolean isTransactional() {
                return this.getTransactionalContext() != null;
            }

            @Override
            public QueueTransactionContext getTransactionalContext() {
                return AbstractQueueSession.this.getTransactionalContext();
            }
        }, this.muleContext);
    }

    protected QueueProvider getQueueProvider() {
        return this.queueProvider;
    }

    protected MuleContext getMuleContext() {
        return this.muleContext;
    }

    protected abstract QueueTransactionContext getTransactionalContext();
}

