/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.SectionedCharBuffer;
import org.neo4j.csv.reader.Source;

public class AutoReadingSource
implements Source {
    private final CharReadable reader;
    private SectionedCharBuffer charBuffer;

    public AutoReadingSource(CharReadable reader, int bufferSize) {
        this.reader = reader;
        this.charBuffer = new SectionedCharBuffer(bufferSize);
    }

    @Override
    public Source.Chunk nextChunk(int seekStartPos) throws IOException {
        this.charBuffer = this.reader.read(this.charBuffer, seekStartPos == -1 ? this.charBuffer.pivot() : seekStartPos);
        return new Source.Chunk(){

            @Override
            public int startPosition() {
                return AutoReadingSource.this.charBuffer.pivot();
            }

            @Override
            public String sourceDescription() {
                return AutoReadingSource.this.reader.sourceDescription();
            }

            @Override
            public int backPosition() {
                return AutoReadingSource.this.charBuffer.back();
            }

            @Override
            public int length() {
                return AutoReadingSource.this.charBuffer.available();
            }

            @Override
            public int maxFieldSize() {
                return AutoReadingSource.this.charBuffer.pivot();
            }

            @Override
            public char[] data() {
                return AutoReadingSource.this.charBuffer.array();
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

