/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.ByteBuffer;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;

public class Buffer {
    private final ByteBuffer buf;
    private final PersistenceWindow persistenceWindow;

    Buffer(PersistenceWindow persistenceWindow, ByteBuffer buf) {
        this.persistenceWindow = persistenceWindow;
        if (buf == null) {
            throw new IllegalArgumentException("null buf");
        }
        this.buf = buf;
    }

    public long position() {
        return this.persistenceWindow.position();
    }

    public ByteBuffer getBuffer() {
        return this.buf;
    }

    public void reset() {
        this.buf.clear();
    }

    public Buffer setOffset(int offset) {
        try {
            this.buf.position(offset);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal position " + offset, e);
        }
        return this;
    }

    public int getOffset() {
        return this.buf.position();
    }

    public Buffer put(byte b) {
        this.buf.put(b);
        return this;
    }

    public Buffer putInt(int i) {
        this.buf.putInt(i);
        return this;
    }

    public Buffer putLong(long l) {
        this.buf.putLong(l);
        return this;
    }

    public byte get() {
        return this.buf.get();
    }

    public int getInt() {
        return this.buf.getInt();
    }

    public long getUnsignedInt() {
        return (long)this.buf.getInt() & 0xFFFFFFFFL;
    }

    public long getLong() {
        return this.buf.getLong();
    }

    public Buffer put(byte[] src) {
        this.buf.put(src);
        return this;
    }

    public Buffer put(char[] src) {
        int oldPos = this.buf.position();
        this.buf.asCharBuffer().put(src);
        this.buf.position(oldPos + src.length * 2);
        return this;
    }

    public Buffer put(byte[] src, int offset, int length) {
        this.buf.put(src, offset, length);
        return this;
    }

    public Buffer get(byte[] dst) {
        this.buf.get(dst);
        return this;
    }

    public Buffer get(char[] dst) {
        this.buf.asCharBuffer().get(dst);
        return this;
    }

    public void close() {
        this.buf.limit(0);
    }

    public String toString() {
        return "Buffer[[" + this.buf.position() + "," + this.buf.capacity() + "]," + this.persistenceWindow + "]";
    }
}

