/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Args {
    private final String[] args;
    private final Map<String, String> map = new HashMap<String, String>();
    private final List<String> orphans = new ArrayList<String>();

    public Args(String ... args) {
        this.args = args;
        this.parseArgs(args);
    }

    public Args(Map<String, String> source) {
        this.args = null;
        this.putAll(source);
    }

    public String[] source() {
        return this.args;
    }

    public Map<String, String> asMap() {
        return new HashMap<String, String>(this.map);
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public String get(String key, String defaultValue) {
        String value = this.map.get(key);
        return value != null ? value : defaultValue;
    }

    public String get(String key, String defaultValueIfNotFound, String defaultValueIfNoValue) {
        String value = this.map.get(key);
        if (value != null) {
            return value;
        }
        return this.map.containsKey(key) ? defaultValueIfNoValue : defaultValueIfNotFound;
    }

    public Number getNumber(String key, Number defaultValue) {
        String value = this.map.get(key);
        return value != null ? (Number)Double.parseDouble(value) : (Number)defaultValue;
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.map.get(key);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public Boolean getBoolean(String key, Boolean defaultValueIfNotFound, Boolean defaultValueIfNoValue) {
        String value = this.map.get(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return this.map.containsKey(key) ? defaultValueIfNoValue : defaultValueIfNotFound;
    }

    public <T extends Enum<T>> T getEnum(Class<T> enumClass, String key, T defaultValue) {
        String raw = this.map.get(key);
        if (raw == null) {
            return defaultValue;
        }
        for (Enum candidate : (Enum[])enumClass.getEnumConstants()) {
            if (!candidate.name().equals(raw)) continue;
            return (T)candidate;
        }
        throw new IllegalArgumentException("No enum instance '" + raw + "' in " + enumClass.getName());
    }

    public Object put(String key, String value) {
        return this.map.put(key, value);
    }

    public void putAll(Map<String, String> source) {
        this.map.putAll(source);
    }

    public List<String> orphans() {
        return new ArrayList<String>(this.orphans);
    }

    public String[] asArgs() {
        String quote;
        ArrayList<String> list = new ArrayList<String>();
        for (String string : this.orphans) {
            quote = string.contains(" ") ? " " : "";
            list.add(quote + string + quote);
        }
        for (Map.Entry entry : this.map.entrySet()) {
            quote = ((String)entry.getKey()).contains(" ") || ((String)entry.getValue()).contains(" ") ? " " : "";
            list.add(quote + (((String)entry.getKey()).length() > 1 ? "--" : "-") + (String)entry.getKey() + "=" + (String)entry.getValue() + quote);
        }
        return list.toArray(new String[0]);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String arg : this.asArgs()) {
            builder.append(builder.length() > 0 ? " " : "").append(arg);
        }
        return builder.toString();
    }

    private static boolean isOption(String arg) {
        return arg.startsWith("-") && arg.length() > 1;
    }

    private static String stripOption(String arg) {
        while (arg.length() > 0 && arg.charAt(0) == '-') {
            arg = arg.substring(1);
        }
        return arg;
    }

    private void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (Args.isOption(arg)) {
                String key;
                int equalIndex = (arg = Args.stripOption(arg)).indexOf(61);
                if (equalIndex != -1) {
                    key = arg.substring(0, equalIndex);
                    String value = arg.substring(equalIndex + 1);
                    if (value.length() <= 0) continue;
                    this.map.put(key, value);
                    continue;
                }
                key = arg;
                int nextIndex = i + 1;
                String value = nextIndex < args.length ? args[nextIndex] : null;
                String string = value = value == null || Args.isOption(value) ? null : value;
                if (value != null) {
                    i = nextIndex;
                }
                this.map.put(key, value);
                continue;
            }
            this.orphans.add(arg);
        }
    }

    public static String jarUsage(Class<?> main, String ... params) {
        StringBuilder usage = new StringBuilder("USAGE: java [-cp ...] ");
        try {
            String jar = main.getProtectionDomain().getCodeSource().getLocation().getPath();
            usage.append("-jar ").append(jar);
        }
        catch (Exception ex) {
            // empty catch block
        }
        usage.append(' ').append(main.getCanonicalName());
        for (String param : params) {
            usage.append(' ').append(param);
        }
        return usage.toString();
    }
}

