/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.neo4j.helpers.Pair;

public abstract class MapUtil {
    public static <K, V> Map<K, V> genericMap(Object ... objects) {
        return MapUtil.genericMap(new HashMap(), objects);
    }

    public static <K, V> Map<K, V> genericMap(Map<K, V> targetMap, Object ... objects) {
        int i = 0;
        while (i < objects.length) {
            targetMap.put(objects[i++], objects[i++]);
        }
        return targetMap;
    }

    public static Map<String, String> stringMap(String ... strings) {
        return MapUtil.genericMap(strings);
    }

    public static Map<String, String> stringMap(Map<String, String> targetMap, String ... strings) {
        return MapUtil.genericMap(targetMap, (Object[])strings);
    }

    public static Map<String, Object> map(Object ... objects) {
        return MapUtil.genericMap(objects);
    }

    public static Map<String, Object> map(Map<String, Object> targetMap, Object ... objects) {
        return MapUtil.genericMap(targetMap, objects);
    }

    public static Map<String, String> load(Reader reader) throws IOException {
        Properties props = new Properties();
        props.load(reader);
        return new HashMap<Object, Object>(props);
    }

    public static Map<String, String> loadStrictly(Reader reader) {
        try {
            return MapUtil.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> load(InputStream stream) throws IOException {
        Properties props = new Properties();
        props.load(stream);
        return new HashMap<Object, Object>(props);
    }

    public static Map<String, String> loadStrictly(InputStream stream) {
        try {
            return MapUtil.load(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> load(File file) throws IOException {
        Map<String, String> map;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            map = MapUtil.load(stream);
        }
        catch (Throwable throwable) {
            MapUtil.closeIfNotNull(stream);
            throw throwable;
        }
        MapUtil.closeIfNotNull(stream);
        return map;
    }

    private static void closeIfNotNull(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static Map<String, String> loadStrictly(File file) {
        try {
            return MapUtil.load(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Map<String, String> config, File file) throws IOException {
        BufferedOutputStream stream = null;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(file));
            MapUtil.store(config, stream);
        }
        catch (Throwable throwable) {
            MapUtil.closeIfNotNull(stream);
            throw throwable;
        }
        MapUtil.closeIfNotNull(stream);
    }

    public static void storeStrictly(Map<String, String> config, File file) {
        try {
            MapUtil.store(config, file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void store(Map<String, String> config, OutputStream stream) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<String, String> property : config.entrySet()) {
            properties.setProperty(property.getKey(), property.getValue());
        }
        properties.store(stream, null);
    }

    public static void storeStrictly(Map<String, String> config, OutputStream stream) {
        try {
            MapUtil.store(config, stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void store(Map<String, String> config, Writer writer) throws IOException {
        Properties properties = new Properties();
        properties.putAll(config);
        properties.store(writer, null);
    }

    public static void storeStrictly(Map<String, String> config, Writer writer) {
        try {
            MapUtil.store(config, writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, V> Map<V, K> reverse(Map<K, V> map) {
        HashMap<V, K> reversedMap = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            reversedMap.put(entry.getValue(), entry.getKey());
        }
        return reversedMap;
    }

    public static <K, V> Map<K, V> copyAndPut(Map<K, V> map, K key, V value) {
        HashMap<K, V> copy = new HashMap<K, V>(map);
        copy.put(key, value);
        return copy;
    }

    public static <K, V> Map<K, V> copyAndRemove(Map<K, V> map, K key) {
        HashMap<K, V> copy = new HashMap<K, V>(map);
        copy.remove(key);
        return copy;
    }

    public static <K, V> Map<K, V> toMap(Iterable<Pair<K, V>> pairs) {
        return MapUtil.toMap(pairs.iterator());
    }

    public static <K, V> Map<K, V> toMap(Iterator<Pair<K, V>> pairs) {
        HashMap<K, V> result = new HashMap<K, V>();
        while (pairs.hasNext()) {
            Pair<K, V> pair = pairs.next();
            result.put(pair.first(), pair.other());
        }
        return result;
    }
}

