/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.concurrent.Callable;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

abstract class LazyProperty<T>
extends DefinedProperty {
    private volatile Object value;

    LazyProperty(int propertyKeyId, Callable<? extends T> producer) {
        super(propertyKeyId);
        this.value = producer;
    }

    @Override
    final boolean hasEqualValue(DefinedProperty that) {
        return this.valueEquals(((LazyProperty)that).value());
    }

    @Override
    public abstract boolean valueEquals(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T value() {
        Object value = this.value;
        if (value instanceof Callable) {
            LazyProperty lazyProperty = this;
            synchronized (lazyProperty) {
                value = this.value;
                if (value instanceof Callable) {
                    this.value = value = this.produceValue();
                }
            }
        }
        return this.castAndPrepareForReturn(value);
    }

    protected Object produceValue() {
        try {
            return ((Callable)this.value).call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected T castAndPrepareForReturn(Object value) {
        return (T)value;
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        int internalSize = SizeOfs.withReference(this.value instanceof Callable ? SizeOfs.withObjectOverhead(0) : SizeOfs.sizeOfObject(this.value));
        return SizeOfs.withObjectOverhead(internalSize);
    }
}

