/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cleanup;

import java.util.Iterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.Thunk;
import org.neo4j.kernel.impl.cleanup.CleanupReference;
import org.neo4j.kernel.impl.cleanup.CleanupReferenceQueue;
import org.neo4j.kernel.impl.cleanup.ReferenceQueueBasedCleanupService;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.Logging;

public abstract class CleanupService
extends LifecycleAdapter {
    private final StringLogger logger;

    public static CleanupService create(JobScheduler scheduler, Logging logging, Thunk<Boolean> cleanupNecessity) {
        return new ReferenceQueueBasedCleanupService(scheduler, logging, new CleanupReferenceQueue(1000L), cleanupNecessity);
    }

    protected CleanupService(Logging logging) {
        this.logger = logging.getMessagesLog(this.getClass());
    }

    public abstract <T> ResourceIterator<T> resourceIterator(Iterator<T> var1, Resource var2);

    void cleanup(CleanupReference reference) {
        try {
            reference.cleanupNow(false);
        }
        catch (Exception e) {
            this.logger.warn("Failure autoclosing a resource during collection", e);
        }
    }

    void logLeakedReference(CleanupReference reference) {
        this.logger.warn(String.format("Resource not closed: %s", reference.description()));
    }
}

