/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store.labels;

import java.util.Collection;
import java.util.HashSet;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicArrayStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.labels.InlineNodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.LabelIdArray;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;

public class DynamicNodeLabels
implements NodeLabels {
    private final long labelField;
    private final NodeRecord node;

    public DynamicNodeLabels(long labelField, NodeRecord node) {
        this.labelField = labelField;
        this.node = node;
    }

    @Override
    public long[] get(NodeStore nodeStore) {
        nodeStore.ensureHeavy(this.node, this.getFirstDynamicRecordId());
        return nodeStore.getDynamicLabelsArray(this.node.getUsedDynamicLabelRecords());
    }

    @Override
    public long[] getIfLoaded() {
        if (this.node.isLight()) {
            return null;
        }
        for (DynamicRecord dynamic : this.node.getUsedDynamicLabelRecords()) {
            if (!dynamic.isLight()) continue;
            return null;
        }
        return LabelIdArray.stripNodeId((long[])DynamicArrayStore.getRightArray(AbstractDynamicStore.readFullByteArrayFromHeavyRecords(this.node.getUsedDynamicLabelRecords(), PropertyType.ARRAY)));
    }

    @Override
    public Collection<DynamicRecord> put(long[] labelIds, NodeStore nodeStore) {
        long existingLabelsField = this.node.getLabelField();
        long existingLabelsBits = NodeLabelsField.parseLabelsBody(existingLabelsField);
        Collection<DynamicRecord> changedDynamicRecords = this.node.getDynamicLabelRecords();
        if (this.labelField != 0L) {
            nodeStore.ensureHeavy(this.node, existingLabelsBits);
            changedDynamicRecords = this.node.getDynamicLabelRecords();
            this.setNotInUse(changedDynamicRecords);
        }
        if (!new InlineNodeLabels(this.labelField, this.node).tryInlineInNodeRecord(labelIds, changedDynamicRecords)) {
            HashSet<DynamicRecord> allRecords = new HashSet<DynamicRecord>(changedDynamicRecords);
            Collection<DynamicRecord> allocatedRecords = nodeStore.allocateRecordsForDynamicLabels(this.node.getId(), labelIds, changedDynamicRecords.iterator());
            allRecords.addAll(allocatedRecords);
            this.node.setLabelField(DynamicNodeLabels.dynamicPointer(allocatedRecords), allocatedRecords);
            changedDynamicRecords = allRecords;
        }
        return changedDynamicRecords;
    }

    @Override
    public Collection<DynamicRecord> add(long labelId, NodeStore nodeStore) {
        nodeStore.ensureHeavy(this.node, NodeLabelsField.parseLabelsBody(this.labelField));
        Collection<DynamicRecord> existingRecords = this.node.getDynamicLabelRecords();
        long[] existingLabelIds = nodeStore.getDynamicLabelsArray(existingRecords);
        long[] newLabelIds = LabelIdArray.concatAndSort(existingLabelIds, labelId);
        Collection<DynamicRecord> changedDynamicRecords = nodeStore.allocateRecordsForDynamicLabels(this.node.getId(), newLabelIds, existingRecords.iterator());
        this.node.setLabelField(DynamicNodeLabels.dynamicPointer(changedDynamicRecords), changedDynamicRecords);
        return changedDynamicRecords;
    }

    @Override
    public Collection<DynamicRecord> remove(long labelId, NodeStore nodeStore) {
        nodeStore.ensureHeavy(this.node, NodeLabelsField.parseLabelsBody(this.labelField));
        Collection<DynamicRecord> existingRecords = this.node.getDynamicLabelRecords();
        long[] existingLabelIds = nodeStore.getDynamicLabelsArray(existingRecords);
        long[] newLabelIds = LabelIdArray.filter(existingLabelIds, labelId);
        if (new InlineNodeLabels(this.labelField, this.node).tryInlineInNodeRecord(newLabelIds, existingRecords)) {
            this.setNotInUse(existingRecords);
        } else {
            Collection<DynamicRecord> newRecords = nodeStore.allocateRecordsForDynamicLabels(this.node.getId(), newLabelIds, existingRecords.iterator());
            this.node.setLabelField(DynamicNodeLabels.dynamicPointer(newRecords), existingRecords);
            if (!newRecords.equals(existingRecords)) {
                for (DynamicRecord record : existingRecords) {
                    if (newRecords.contains(record)) continue;
                    record.setInUse(false);
                    record.setLength(0);
                }
            }
        }
        return existingRecords;
    }

    @Override
    public void ensureHeavy(NodeStore nodeStore) {
        nodeStore.ensureHeavy(this.node, this.getFirstDynamicRecordId());
    }

    public static long dynamicPointer(Collection<DynamicRecord> newRecords) {
        return 0x8000000000L | IteratorUtil.first(newRecords).getId();
    }

    public long getFirstDynamicRecordId() {
        return NodeLabelsField.parseLabelsBody(this.labelField);
    }

    private void setNotInUse(Collection<DynamicRecord> changedDynamicRecords) {
        for (DynamicRecord record : changedDynamicRecords) {
            record.setInUse(false);
        }
    }

    @Override
    public boolean isInlined() {
        return false;
    }

    public String toString() {
        return String.format("Dynamic(id:%d)", this.getFirstDynamicRecordId());
    }
}

