/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.IOException;
import java.util.Collection;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.TokenRecord;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;

public class TransactionWriter {
    private final LogBuffer buffer;
    private final int identifier;
    private final int localId;

    public TransactionWriter(LogBuffer buffer, int identifier, int localId) {
        this.buffer = buffer;
        this.identifier = identifier;
        this.localId = localId;
    }

    public void start(int masterId, int myId, long latestCommittedTxWhenTxStarted) throws IOException {
        this.start(XidImpl.getNewGlobalId(XidImpl.DEFAULT_SEED, this.localId), masterId, myId, System.currentTimeMillis(), latestCommittedTxWhenTxStarted);
    }

    public void start(byte[] globalId, int masterId, int myId, long startTimestamp, long latestCommittedTxWhenTxStarted) throws IOException {
        XidImpl xid = new XidImpl(globalId, NeoStoreXaDataSource.BRANCH_ID);
        LogIoUtils.writeStart(this.buffer, this.identifier, xid, masterId, myId, startTimestamp, latestCommittedTxWhenTxStarted);
    }

    public void prepare() throws IOException {
        this.prepare(System.currentTimeMillis());
    }

    public void prepare(long prepareTimestamp) throws IOException {
        LogIoUtils.writePrepare(this.buffer, this.identifier, prepareTimestamp);
    }

    public void commit(boolean twoPhase, long txId) throws IOException {
        this.commit(twoPhase, txId, System.currentTimeMillis());
    }

    public void commit(boolean twoPhase, long txId, long commitTimestamp) throws IOException {
        LogIoUtils.writeCommit(twoPhase, this.buffer, this.identifier, txId, commitTimestamp);
    }

    public void done() throws IOException {
        LogIoUtils.writeDone(this.buffer, this.identifier);
    }

    public void propertyKey(int id, String key, int ... dynamicIds) throws IOException {
        this.write(new Command.PropertyKeyTokenCommand(null, TransactionWriter.withName(new PropertyKeyTokenRecord(id), dynamicIds, key)));
    }

    public void label(int id, String name, int ... dynamicIds) throws IOException {
        this.write(new Command.LabelTokenCommand(null, TransactionWriter.withName(new LabelTokenRecord(id), dynamicIds, name)));
    }

    public void relationshipType(int id, String label, int ... dynamicIds) throws IOException {
        this.write(new Command.RelationshipTypeTokenCommand(null, TransactionWriter.withName(new RelationshipTypeTokenRecord(id), dynamicIds, label)));
    }

    public void update(NeoStoreRecord record) throws IOException {
        this.write(new Command.NeoStoreCommand(null, record));
    }

    public void create(NodeRecord node) throws IOException {
        node.setCreated();
        this.update(new NodeRecord(node.getId(), Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue()), node);
    }

    public void update(NodeRecord before, NodeRecord node) throws IOException {
        node.setInUse(true);
        this.add(before, node);
    }

    public void delete(NodeRecord node) throws IOException {
        node.setInUse(false);
        this.add(node, new NodeRecord(node.getId(), Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue()));
    }

    public void create(RelationshipRecord relationship) throws IOException {
        relationship.setCreated();
        this.update(relationship);
    }

    public void createSchema(Collection<DynamicRecord> beforeRecord, Collection<DynamicRecord> afterRecord) throws IOException {
        for (DynamicRecord record : afterRecord) {
            record.setCreated();
        }
        this.updateSchema(beforeRecord, afterRecord);
    }

    public void updateSchema(Collection<DynamicRecord> beforeRecords, Collection<DynamicRecord> afterRecords) throws IOException {
        for (DynamicRecord record : afterRecords) {
            record.setInUse(true);
        }
        this.addSchema(beforeRecords, afterRecords);
    }

    public void update(RelationshipRecord relationship) throws IOException {
        relationship.setInUse(true);
        this.add(relationship);
    }

    public void delete(RelationshipRecord relationship) throws IOException {
        relationship.setInUse(false);
        this.add(relationship);
    }

    public void create(PropertyRecord property) throws IOException {
        property.setCreated();
        PropertyRecord before = new PropertyRecord(property.getLongId());
        if (property.isNodeSet()) {
            before.setNodeId(property.getNodeId());
        }
        if (property.isRelSet()) {
            before.setRelId(property.getRelId());
        }
        this.update(before, property);
    }

    public void update(PropertyRecord before, PropertyRecord after) throws IOException {
        after.setInUse(true);
        this.add(before, after);
    }

    public void delete(PropertyRecord before, PropertyRecord after) throws IOException {
        after.setInUse(false);
        this.add(before, after);
    }

    private void addSchema(Collection<DynamicRecord> beforeRecords, Collection<DynamicRecord> afterRecords) throws IOException {
        this.write(new Command.SchemaRuleCommand(null, null, null, beforeRecords, afterRecords, null, Long.MAX_VALUE));
    }

    public void add(NodeRecord before, NodeRecord after) throws IOException {
        this.write(new Command.NodeCommand(null, before, after));
    }

    public void add(RelationshipRecord relationship) throws IOException {
        this.write(new Command.RelationshipCommand(null, relationship));
    }

    public void add(PropertyRecord before, PropertyRecord property) throws IOException {
        this.write(new Command.PropertyCommand(null, before, property));
    }

    public void add(RelationshipTypeTokenRecord record) throws IOException {
        this.write(new Command.RelationshipTypeTokenCommand(null, record));
    }

    public void add(PropertyKeyTokenRecord record) throws IOException {
        this.write(new Command.PropertyKeyTokenCommand(null, record));
    }

    public void add(NeoStoreRecord record) throws IOException {
        this.write(new Command.NeoStoreCommand(null, record));
    }

    private void write(Command command) throws IOException {
        LogIoUtils.writeCommand(this.buffer, this.identifier, command);
    }

    private static <T extends TokenRecord> T withName(T record, int[] dynamicIds, String name) {
        if (dynamicIds == null || dynamicIds.length == 0) {
            throw new IllegalArgumentException("No dynamic records for storing the name.");
        }
        record.setInUse(true);
        byte[] data = PropertyStore.encodeString(name);
        if (data.length > dynamicIds.length * 30) {
            throw new IllegalArgumentException(String.format("[%s] is too long to fit in %d blocks", name, dynamicIds.length));
        }
        if (data.length <= (dynamicIds.length - 1) * 30) {
            throw new IllegalArgumentException(String.format("[%s] is to short to fill %d blocks", name, dynamicIds.length));
        }
        for (int i = 0; i < dynamicIds.length; ++i) {
            byte[] part = new byte[Math.min(30, data.length - i * 30)];
            System.arraycopy(data, i * 30, part, 0, part.length);
            DynamicRecord dynamicRecord = new DynamicRecord(dynamicIds[i]);
            dynamicRecord.setInUse(true);
            dynamicRecord.setData(part);
            dynamicRecord.setCreated();
            record.addNameRecord(dynamicRecord);
        }
        record.setNameId(dynamicIds[0]);
        return record;
    }
}

