/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.xaframework.InjectedTransactionValidator;
import org.neo4j.kernel.impl.transaction.xaframework.InterceptingXaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.xaframework.NoOpLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class XaFactory {
    private Config config;
    private final TxIdGenerator txIdGenerator;
    private final AbstractTransactionManager txManager;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final Monitors monitors;
    private final Logging logging;
    private final RecoveryVerifier recoveryVerifier;
    private final LogPruneStrategy pruneStrategy;

    public XaFactory(Config config, TxIdGenerator txIdGenerator, AbstractTransactionManager txManager, FileSystemAbstraction fileSystemAbstraction, Monitors monitors, Logging logging, RecoveryVerifier recoveryVerifier, LogPruneStrategy pruneStrategy) {
        this.config = config;
        this.txIdGenerator = txIdGenerator;
        this.txManager = txManager;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.monitors = monitors;
        this.logging = logging;
        this.recoveryVerifier = recoveryVerifier;
        this.pruneStrategy = pruneStrategy;
    }

    public XaContainer newXaContainer(XaDataSource xaDataSource, File logicalLog, XaCommandFactory cf, InjectedTransactionValidator injectedTxValidator, XaTransactionFactory tf, TransactionStateFactory stateFactory, TransactionInterceptorProviders providers, boolean readOnly) {
        if (logicalLog == null || cf == null || tf == null) {
            throw new IllegalArgumentException("Null parameter, LogicalLog[" + logicalLog + "] CommandFactory[" + cf + "TransactionFactory[" + tf + "]");
        }
        XaResourceManager rm = new XaResourceManager(xaDataSource, tf, this.txIdGenerator, this.txManager, this.recoveryVerifier, logicalLog.getName(), this.monitors);
        long rotateAtSize = this.config.get(GraphDatabaseSettings.logical_log_rotation_threshold);
        XaLogicalLog log = readOnly ? new NoOpLogicalLog(this.logging) : (providers.shouldInterceptDeserialized() && providers.hasAnyInterceptorConfigured() ? new InterceptingXaLogicalLog(logicalLog, rm, cf, tf, providers, this.monitors, this.fileSystemAbstraction, this.logging, this.pruneStrategy, stateFactory, rotateAtSize, injectedTxValidator) : new XaLogicalLog(logicalLog, rm, cf, tf, this.fileSystemAbstraction, this.monitors, this.logging, this.pruneStrategy, stateFactory, rotateAtSize, injectedTxValidator));
        rm.setLogicalLog(log);
        tf.setLogicalLog(log);
        return new XaContainer(rm, log);
    }
}

