/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class FirstItemIterable<T>
implements Iterable<T> {
    private final T first;
    private final Iterator<T> iterator;
    private int pos = -1;

    public FirstItemIterable(Iterable<T> data) {
        this(data.iterator());
    }

    public FirstItemIterable(Iterator<T> iterator) {
        this.iterator = iterator;
        if (iterator.hasNext()) {
            this.first = iterator.next();
            this.pos = 0;
        } else {
            this.first = null;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return FirstItemIterable.this.pos == 0 || FirstItemIterable.this.iterator.hasNext();
            }

            @Override
            public T next() {
                if (FirstItemIterable.this.pos < 0) {
                    throw new NoSuchElementException();
                }
                return FirstItemIterable.this.pos++ == 0 ? FirstItemIterable.this.first : FirstItemIterable.this.iterator.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    public T getFirst() {
        return this.first;
    }
}

