/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

class DoubleArrayProperty
extends DefinedProperty {
    private final double[] value;

    DoubleArrayProperty(int propertyKeyId, double[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public double[] value() {
        return (double[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object value) {
        if (value instanceof double[]) {
            return Arrays.equals(this.value, (double[])value);
        }
        return this.valueCompare(this.value, value);
    }

    @Override
    int valueHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    boolean hasEqualValue(DefinedProperty that) {
        return Arrays.equals(this.value, ((DoubleArrayProperty)that).value);
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(SizeOfs.withReference(SizeOfs.sizeOfArray(this.value)));
    }
}

