/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.impl.api.operations.LegacyKernelOperations;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.transaction.LockType;

public class DefaultLegacyKernelOperations
implements LegacyKernelOperations {
    private final NodeManager nodeManager;

    public DefaultLegacyKernelOperations(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    @Override
    public long nodeCreate(Statement state) {
        return this.nodeManager.createNode().getId();
    }

    @Override
    public long relationshipCreate(Statement state, long relationshipTypeId, long startNodeId, long endNodeId) throws RelationshipTypeIdNotFoundKernelException, EntityNotFoundException {
        NodeImpl startNode;
        try {
            startNode = this.nodeManager.getNodeForProxy(startNodeId, LockType.WRITE);
        }
        catch (NotFoundException e) {
            throw new EntityNotFoundException(EntityType.NODE, startNodeId, e);
        }
        try {
            return this.nodeManager.createRelationship(this.nodeManager.newNodeProxyById(startNodeId), startNode, this.nodeManager.newNodeProxyById(endNodeId), relationshipTypeId).getId();
        }
        catch (NotFoundException e) {
            throw new EntityNotFoundException(EntityType.NODE, endNodeId, e);
        }
    }
}

