/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Iterator;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.store.CacheLoader;
import org.neo4j.kernel.impl.api.store.DiskLayer;
import org.neo4j.kernel.impl.api.store.PersistenceCache;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaStorage;
import org.neo4j.kernel.impl.util.PrimitiveIntIterator;
import org.neo4j.kernel.impl.util.PrimitiveIntIteratorForArray;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;

public class CacheLayer
implements StoreReadLayer {
    private static final Function<? super SchemaRule, IndexDescriptor> TO_INDEX_RULE = new Function<SchemaRule, IndexDescriptor>(){

        @Override
        public IndexDescriptor apply(SchemaRule from) {
            IndexRule rule = (IndexRule)from;
            return new IndexDescriptor(rule.getLabel(), rule.getPropertyKey());
        }
    };
    private final CacheLoader<Iterator<DefinedProperty>> nodePropertyLoader = new CacheLoader<Iterator<DefinedProperty>>(){

        @Override
        public Iterator<DefinedProperty> load(long id) throws EntityNotFoundException {
            return CacheLayer.this.diskLayer.nodeGetAllProperties(id);
        }
    };
    private final CacheLoader<Iterator<DefinedProperty>> relationshipPropertyLoader = new CacheLoader<Iterator<DefinedProperty>>(){

        @Override
        public Iterator<DefinedProperty> load(long id) throws EntityNotFoundException {
            return CacheLayer.this.diskLayer.relationshipGetAllProperties(id);
        }
    };
    private final CacheLoader<Iterator<DefinedProperty>> graphPropertyLoader = new CacheLoader<Iterator<DefinedProperty>>(){

        @Override
        public Iterator<DefinedProperty> load(long id) throws EntityNotFoundException {
            return CacheLayer.this.diskLayer.graphGetAllProperties();
        }
    };
    private final CacheLoader<int[]> nodeLabelLoader = new CacheLoader<int[]>(){

        @Override
        public int[] load(long id) throws EntityNotFoundException {
            return PrimitiveIntIteratorForArray.primitiveIntIteratorToIntArray(CacheLayer.this.diskLayer.nodeGetLabels(id));
        }
    };
    private final PersistenceCache persistenceCache;
    private final SchemaCache schemaCache;
    private final DiskLayer diskLayer;
    private final IndexingService indexingService;

    public CacheLayer(DiskLayer diskLayer, PersistenceCache persistenceCache, IndexingService indexingService, SchemaCache schemaCache) {
        this.diskLayer = diskLayer;
        this.persistenceCache = persistenceCache;
        this.indexingService = indexingService;
        this.schemaCache = schemaCache;
    }

    @Override
    public boolean nodeHasLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        return this.persistenceCache.nodeHasLabel(state, nodeId, labelId, this.nodeLabelLoader);
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(KernelStatement state, long nodeId) throws EntityNotFoundException {
        return new PrimitiveIntIteratorForArray(this.persistenceCache.nodeGetLabels(state, nodeId, this.nodeLabelLoader));
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(KernelStatement state, int labelId) {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRulesForLabel(labelId), SchemaRule.Kind.INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(KernelStatement state) {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRules(), SchemaRule.Kind.INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(KernelStatement state, int labelId) {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRulesForLabel(labelId), SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll(KernelStatement state) {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRules(), SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
    }

    private static Iterator<IndexDescriptor> toIndexDescriptors(Iterable<SchemaRule> rules, final SchemaRule.Kind kind) {
        Iterator<SchemaRule> filteredRules = Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule item) {
                return item.getKind() == kind;
            }
        }, rules.iterator());
        return Iterables.map(TO_INDEX_RULE, filteredRules);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(index, SchemaStorage.IndexRuleKind.ALL);
        if (rule != null) {
            return rule.getOwningConstraint();
        }
        return this.diskLayer.indexGetOwningUniquenessConstraintId(index);
    }

    @Override
    public long indexGetCommittedId(KernelStatement state, IndexDescriptor index, SchemaStorage.IndexRuleKind kind) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(index, kind);
        if (rule != null) {
            return rule.getId();
        }
        return this.diskLayer.indexGetCommittedId(index);
    }

    @Override
    public IndexRule indexRule(IndexDescriptor index, SchemaStorage.IndexRuleKind kind) {
        for (SchemaRule rule : this.schemaCache.schemaRulesForLabel(index.getLabelId())) {
            IndexRule indexRule;
            if (!(rule instanceof IndexRule) || !kind.isOfKind(indexRule = (IndexRule)rule) || indexRule.getPropertyKey() != index.getPropertyKeyId()) continue;
            return indexRule;
        }
        return null;
    }

    @Override
    public PrimitiveLongIterator nodeGetPropertyKeys(KernelStatement state, long nodeId) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetPropertyKeys(nodeId, this.nodePropertyLoader);
    }

    @Override
    public Property nodeGetProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetProperty(nodeId, propertyKeyId, this.nodePropertyLoader);
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllProperties(KernelStatement state, long nodeId) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetProperties(nodeId, this.nodePropertyLoader);
    }

    @Override
    public PrimitiveLongIterator relationshipGetPropertyKeys(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        return new PropertyKeyIdIterator(this.relationshipGetAllProperties(state, relationshipId));
    }

    @Override
    public Property relationshipGetProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        return this.persistenceCache.relationshipGetProperty(relationshipId, propertyKeyId, this.relationshipPropertyLoader);
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllProperties(KernelStatement state, long nodeId) throws EntityNotFoundException {
        return this.persistenceCache.relationshipGetProperties(nodeId, this.relationshipPropertyLoader);
    }

    @Override
    public PrimitiveLongIterator graphGetPropertyKeys(KernelStatement state) {
        return this.persistenceCache.graphGetPropertyKeys(this.graphPropertyLoader);
    }

    @Override
    public Property graphGetProperty(KernelStatement state, int propertyKeyId) {
        return this.persistenceCache.graphGetProperty(this.graphPropertyLoader, propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties(KernelStatement state) {
        return this.persistenceCache.graphGetProperties(this.graphPropertyLoader);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKeyId) {
        return this.schemaCache.constraintsForLabelAndProperty(labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(KernelStatement state, int labelId) {
        return this.schemaCache.constraintsForLabel(labelId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll(KernelStatement state) {
        return this.schemaCache.constraints();
    }

    @Override
    public PrimitiveLongIterator nodeGetUniqueFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        return this.diskLayer.nodeGetUniqueFromIndexLookup(state, this.schemaCache.indexId(index), value);
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        return this.diskLayer.nodesGetForLabel(state, labelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        return this.diskLayer.nodesGetFromIndexLookup(state, this.schemaCache.indexId(index), value);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKey) throws SchemaRuleNotFoundException {
        return this.schemaCache.indexDescriptor(labelId, propertyKey);
    }

    @Override
    public InternalIndexState indexGetState(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexingService.getProxyForRule(this.schemaCache.indexId(descriptor)).getState();
    }

    @Override
    public String indexGetFailure(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.diskLayer.indexGetFailure(descriptor);
    }

    @Override
    public int labelGetForName(String labelName) {
        return this.diskLayer.labelGetForName(labelName);
    }

    @Override
    public String labelGetName(int labelId) throws LabelNotFoundKernelException {
        return this.diskLayer.labelGetName(labelId);
    }

    @Override
    public int propertyKeyGetForName(String propertyKeyName) {
        return this.diskLayer.propertyKeyGetForName(propertyKeyName);
    }

    @Override
    public int propertyKeyGetOrCreateForName(String propertyKeyName) {
        return this.diskLayer.propertyKeyGetOrCreateForName(propertyKeyName);
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        return this.diskLayer.propertyKeyGetName(propertyKeyId);
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens() {
        return this.diskLayer.propertyKeyGetAllTokens().iterator();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        return this.diskLayer.labelGetAllTokens().iterator();
    }

    @Override
    public int relationshipTypeGetForName(String relationshipTypeName) {
        return this.diskLayer.relationshipTypeGetForName(relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        return this.diskLayer.relationshipTypeGetName(relationshipTypeId);
    }

    @Override
    public int labelGetOrCreateForName(String labelName) throws TooManyLabelsException {
        return this.diskLayer.labelGetOrCreateForName(labelName);
    }

    @Override
    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) {
        return this.diskLayer.relationshipTypeGetOrCreateForName(relationshipTypeName);
    }
}

