/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdArrayWithLoops;

public class RelationshipLoader {
    private final PersistenceManager persistenceManager;
    private final Cache<RelationshipImpl> relationshipCache;

    public RelationshipLoader(PersistenceManager persistenceManager, Cache<RelationshipImpl> relationshipCache) {
        this.persistenceManager = persistenceManager;
        this.relationshipCache = relationshipCache;
    }

    public Triplet<ArrayMap<Integer, RelIdArray>, List<RelationshipImpl>, Long> getMoreRelationships(NodeImpl node) {
        boolean hasLoops;
        long nodeId = node.getId();
        long position = node.getRelChainPosition();
        Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, Long> rels = this.persistenceManager.getMoreRelationships(nodeId, position);
        ArrayMap<Integer, RelIdArray> newRelationshipMap = new ArrayMap<Integer, RelIdArray>();
        ArrayList<RelationshipImpl> relsList = new ArrayList<RelationshipImpl>(150);
        Iterable<RelationshipRecord> loops = rels.first().get((Object)RelIdArray.DirectionWrapper.BOTH);
        boolean bl = hasLoops = loops != null;
        if (hasLoops) {
            this.populateLoadedRelationships(loops, relsList, RelIdArray.DirectionWrapper.BOTH, true, newRelationshipMap);
        }
        this.populateLoadedRelationships(rels.first().get((Object)RelIdArray.DirectionWrapper.OUTGOING), relsList, RelIdArray.DirectionWrapper.OUTGOING, hasLoops, newRelationshipMap);
        this.populateLoadedRelationships(rels.first().get((Object)RelIdArray.DirectionWrapper.INCOMING), relsList, RelIdArray.DirectionWrapper.INCOMING, hasLoops, newRelationshipMap);
        return Triplet.of(newRelationshipMap, relsList, rels.other());
    }

    private void populateLoadedRelationships(Iterable<RelationshipRecord> loadedRelationshipRecords, List<RelationshipImpl> relsList, RelIdArray.DirectionWrapper dir, boolean hasLoops, ArrayMap<Integer, RelIdArray> loadedRelationshipsOutputParameter) {
        for (RelationshipRecord rel : loadedRelationshipRecords) {
            long relId = rel.getId();
            RelationshipImpl relImpl = this.getOrCreateRelationshipFromCache(relsList, rel, relId);
            this.getOrCreateRelationships(hasLoops, relImpl.getTypeId(), loadedRelationshipsOutputParameter).add(relId, dir);
        }
    }

    private RelIdArray getOrCreateRelationships(boolean hasLoops, int typeId, ArrayMap<Integer, RelIdArray> loadedRelationships) {
        RelIdArray relIdArray = loadedRelationships.get(typeId);
        if (relIdArray != null) {
            return relIdArray;
        }
        RelIdArray loadedRelIdArray = hasLoops ? new RelIdArrayWithLoops(typeId) : new RelIdArray(typeId);
        loadedRelationships.put(typeId, loadedRelIdArray);
        return loadedRelIdArray;
    }

    private RelationshipImpl getOrCreateRelationshipFromCache(List<RelationshipImpl> newlyCreatedRelationships, RelationshipRecord rel, long relId) {
        RelationshipImpl relImpl = this.relationshipCache.get(relId);
        if (relImpl != null) {
            return relImpl;
        }
        RelationshipImpl loadedRelImpl = new RelationshipImpl(relId, rel.getFirstNode(), rel.getSecondNode(), rel.getType(), false);
        newlyCreatedRelationships.add(loadedRelImpl);
        return loadedRelImpl;
    }
}

