/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;

public class InMemoryLogBuffer
implements LogBuffer,
ReadableByteChannel {
    private byte[] bytes = new byte[1000];
    private int writeIndex;
    private int readIndex;
    private ByteBuffer bufferForConversions = ByteBuffer.wrap(new byte[100]);

    public void reset() {
        this.readIndex = 0;
        this.writeIndex = 0;
    }

    private void ensureArrayCapacityPlus(int plus) {
        while (this.writeIndex + plus > this.bytes.length) {
            byte[] tmp = this.bytes;
            this.bytes = new byte[this.bytes.length * 2];
            System.arraycopy(tmp, 0, this.bytes, 0, tmp.length);
        }
    }

    private LogBuffer flipAndPut() {
        this.ensureArrayCapacityPlus(this.bufferForConversions.limit());
        System.arraycopy(this.bufferForConversions.flip().array(), 0, this.bytes, this.writeIndex, this.bufferForConversions.limit());
        this.writeIndex += this.bufferForConversions.limit();
        return this;
    }

    @Override
    public LogBuffer put(byte b) throws IOException {
        this.ensureArrayCapacityPlus(1);
        this.bytes[this.writeIndex++] = b;
        return this;
    }

    @Override
    public LogBuffer putShort(short s) throws IOException {
        ((ByteBuffer)this.bufferForConversions.clear()).putShort(s);
        return this.flipAndPut();
    }

    @Override
    public LogBuffer putInt(int i) throws IOException {
        ((ByteBuffer)this.bufferForConversions.clear()).putInt(i);
        return this.flipAndPut();
    }

    @Override
    public LogBuffer putLong(long l) throws IOException {
        ((ByteBuffer)this.bufferForConversions.clear()).putLong(l);
        return this.flipAndPut();
    }

    @Override
    public LogBuffer putFloat(float f) throws IOException {
        ((ByteBuffer)this.bufferForConversions.clear()).putFloat(f);
        return this.flipAndPut();
    }

    @Override
    public LogBuffer putDouble(double d) throws IOException {
        ((ByteBuffer)this.bufferForConversions.clear()).putDouble(d);
        return this.flipAndPut();
    }

    @Override
    public LogBuffer put(byte[] bytes) throws IOException {
        this.ensureArrayCapacityPlus(bytes.length);
        System.arraycopy(bytes, 0, this.bytes, this.writeIndex, bytes.length);
        this.writeIndex += bytes.length;
        return this;
    }

    @Override
    public LogBuffer put(char[] chars) throws IOException {
        this.ensureConversionBufferCapacity(chars.length * 2);
        this.bufferForConversions.clear();
        for (char ch : chars) {
            this.bufferForConversions.putChar(ch);
        }
        return this.flipAndPut();
    }

    private void ensureConversionBufferCapacity(int length) {
        if (this.bufferForConversions.capacity() < length) {
            this.bufferForConversions = ByteBuffer.wrap(new byte[length * 2]);
        }
    }

    @Override
    public void writeOut() throws IOException {
    }

    @Override
    public void force() throws IOException {
    }

    @Override
    public long getFileChannelPosition() throws IOException {
        return this.readIndex;
    }

    @Override
    public StoreChannel getFileChannel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.readIndex >= this.writeIndex) {
            return -1;
        }
        int actualLengthToRead = Math.min(dst.limit(), this.writeIndex - this.readIndex);
        try {
            dst.put(this.bytes, this.readIndex, actualLengthToRead);
            int n = actualLengthToRead;
            return n;
        }
        finally {
            this.readIndex += actualLengthToRead;
        }
    }
}

