/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.core.GraphPropertiesImpl;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.locking.AcquireLockTimeoutException;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.DiffSets;

public class OldTxStateBridgeImpl
implements OldTxStateBridge {
    private final NodeManager nodeManager;
    private final TransactionState state;

    public OldTxStateBridgeImpl(NodeManager nodeManager, TransactionState transactionState) {
        this.nodeManager = nodeManager;
        this.state = transactionState;
    }

    @Override
    public DiffSets<Long> getNodesWithChangedProperty(int propertyKey, Object value) {
        DiffSets<Long> diff = new DiffSets<Long>();
        for (WritableTransactionState.CowNodeElement changedNode : this.state.getChangedNodes()) {
            DefinedProperty added;
            DefinedProperty removed = OldTxStateBridgeImpl.propertyChange(changedNode.getPropertyRemoveMap(false), propertyKey);
            if (removed != null && removed.value().equals(value)) {
                diff.remove(changedNode.getId());
            }
            if (changedNode.isDeleted() || (added = OldTxStateBridgeImpl.propertyChange(changedNode.getPropertyAddMap(false), propertyKey)) == null) continue;
            if (added.valueEquals(value)) {
                diff.add(changedNode.getId());
                continue;
            }
            diff.remove(changedNode.getId());
        }
        return diff;
    }

    @Override
    public Map<Long, Object> getNodesWithChangedProperty(int propertyKeyId) {
        HashMap<Long, Object> result = new HashMap<Long, Object>();
        for (WritableTransactionState.CowNodeElement changedNode : this.state.getChangedNodes()) {
            if (changedNode.isDeleted()) {
                result.put(changedNode.getId(), new Object());
                continue;
            }
            DefinedProperty added = OldTxStateBridgeImpl.propertyChange(changedNode.getPropertyAddMap(false), propertyKeyId);
            if (added != null) {
                result.put(changedNode.getId(), added.value());
                continue;
            }
            if (null == OldTxStateBridgeImpl.propertyChange(changedNode.getPropertyRemoveMap(false), propertyKeyId)) continue;
            result.put(changedNode.getId(), new Object());
        }
        return result;
    }

    private static DefinedProperty propertyChange(ArrayMap<Integer, DefinedProperty> propertyDataMap, long propertyKeyId) {
        return propertyDataMap == null ? null : propertyDataMap.get((int)propertyKeyId);
    }

    @Override
    public long relationshipCreate(int relationshipTypeId, long startNodeId, long endNodeId) {
        NodeImpl startNode = this.nodeManager.getNodeForProxy(startNodeId);
        return this.nodeManager.createRelationship(this.nodeManager.newNodeProxyById(startNodeId), startNode, this.nodeManager.newNodeProxyById(endNodeId), relationshipTypeId);
    }

    @Override
    public long nodeCreate() throws AcquireLockTimeoutException {
        return this.nodeManager.createNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNode(long nodeId) {
        NodeImpl node = this.nodeManager.getNodeForProxy(nodeId);
        boolean success = false;
        try {
            ArrayMap<Integer, DefinedProperty> skipMap = this.state.getOrCreateCowPropertyRemoveMap(node);
            ArrayMap<Integer, DefinedProperty> removedProps = this.nodeManager.deleteNode(node, this.state);
            if (removedProps.size() > 0) {
                for (Integer index : removedProps.keySet()) {
                    skipMap.put(index, removedProps.get(index));
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.nodeManager.setRollbackOnly();
            }
        }
    }

    @Override
    public boolean nodeIsAddedInThisTx(long nodeId) {
        return this.state.getCreatedNodes().contains(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRelationship(long relationshipId) {
        RelationshipImpl relationship = this.nodeManager.getRelationshipForProxy(relationshipId);
        boolean success = false;
        try {
            ArrayMap<Integer, DefinedProperty> skipMap = this.state.getOrCreateCowPropertyRemoveMap(relationship);
            ArrayMap<Integer, DefinedProperty> removedProps = this.nodeManager.deleteRelationship(relationship, this.state);
            if (removedProps.size() > 0) {
                for (Integer index : removedProps.keySet()) {
                    skipMap.put(index, removedProps.get(index));
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.nodeManager.setRollbackOnly();
            }
        }
    }

    @Override
    public boolean relationshipIsAddedInThisTx(long relationshipId) {
        return this.state.getCreatedRelationships().contains(relationshipId);
    }

    @Override
    public boolean hasChanges() {
        return this.state.hasChanges();
    }

    @Override
    public void nodeSetProperty(long nodeId, DefinedProperty property) {
        NodeImpl node = this.nodeManager.getNodeForProxy(nodeId);
        this.state.getOrCreateCowPropertyAddMap(node).put(property.propertyKeyId(), property);
        ArrayMap<Integer, DefinedProperty> removed = this.state.getCowPropertyRemoveMap(node);
        if (removed != null) {
            removed.remove(property.propertyKeyId());
        }
    }

    @Override
    public void relationshipSetProperty(long relationshipId, DefinedProperty property) {
        RelationshipImpl relationship = this.nodeManager.getRelationshipForProxy(relationshipId);
        this.state.getOrCreateCowPropertyAddMap(relationship).put(property.propertyKeyId(), property);
        ArrayMap<Integer, DefinedProperty> removed = this.state.getCowPropertyRemoveMap(relationship);
        if (removed != null) {
            removed.remove(property.propertyKeyId());
        }
    }

    @Override
    public void graphSetProperty(DefinedProperty property) {
        GraphPropertiesImpl properties = this.nodeManager.getGraphProperties();
        this.state.getOrCreateCowPropertyAddMap(properties).put(property.propertyKeyId(), property);
        ArrayMap<Integer, DefinedProperty> removed = this.state.getCowPropertyRemoveMap(properties);
        if (removed != null) {
            removed.remove(property.propertyKeyId());
        }
    }

    @Override
    public void nodeRemoveProperty(long nodeId, DefinedProperty property) {
        NodeImpl node = this.nodeManager.getNodeForProxy(nodeId);
        this.state.getOrCreateCowPropertyRemoveMap(node).put(property.propertyKeyId(), property);
        ArrayMap<Integer, DefinedProperty> added = this.state.getCowPropertyAddMap(node);
        if (added != null) {
            added.remove(property.propertyKeyId());
        }
    }

    @Override
    public void relationshipRemoveProperty(long relationshipId, DefinedProperty property) {
        RelationshipImpl relationship = this.nodeManager.getRelationshipForProxy(relationshipId);
        this.state.getOrCreateCowPropertyRemoveMap(relationship).put(property.propertyKeyId(), property);
        ArrayMap<Integer, DefinedProperty> added = this.state.getCowPropertyAddMap(relationship);
        if (added != null) {
            added.remove(property.propertyKeyId());
        }
    }

    @Override
    public void graphRemoveProperty(DefinedProperty property) {
        GraphPropertiesImpl properties = this.nodeManager.getGraphProperties();
        this.state.getOrCreateCowPropertyRemoveMap(properties).put(property.propertyKeyId(), property);
        ArrayMap<Integer, DefinedProperty> added = this.state.getCowPropertyAddMap(properties);
        if (added != null) {
            added.remove(property.propertyKeyId());
        }
    }
}

