/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.Provider;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

public class PropertyContainerLocker {
    public Lock exclusiveLock(Provider<Statement> stmtProvider, PropertyContainer container) {
        Throwable throwable = null;
        try (Statement statement = stmtProvider.instance();){
            if (container instanceof Node) {
                statement.readOperations().acquireExclusive(ResourceTypes.NODE, ((Node)container).getId());
                CoreAPILock coreAPILock = new CoreAPILock(stmtProvider, ResourceTypes.NODE, ((Node)container).getId()){

                    @Override
                    void release(Statement statement, Locks.ResourceType type, long resourceId) {
                        statement.readOperations().releaseExclusive(type, resourceId);
                    }
                };
                return coreAPILock;
            }
            if (container instanceof Relationship) {
                statement.readOperations().acquireExclusive(ResourceTypes.RELATIONSHIP, ((Relationship)container).getId());
                CoreAPILock coreAPILock = new CoreAPILock(stmtProvider, ResourceTypes.RELATIONSHIP, ((Relationship)container).getId()){

                    @Override
                    void release(Statement statement, Locks.ResourceType type, long resourceId) {
                        statement.readOperations().releaseExclusive(type, resourceId);
                    }
                };
                return coreAPILock;
            }
            try {
                throw new UnsupportedOperationException("Only relationships and nodes can be locked.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Lock sharedLock(Provider<Statement> stmtProvider, PropertyContainer container) {
        Throwable throwable = null;
        try (Statement statement = stmtProvider.instance();){
            if (container instanceof Node) {
                statement.readOperations().acquireShared(ResourceTypes.NODE, ((Node)container).getId());
                CoreAPILock coreAPILock = new CoreAPILock(stmtProvider, ResourceTypes.NODE, ((Node)container).getId()){

                    @Override
                    void release(Statement statement, Locks.ResourceType type, long resourceId) {
                        statement.readOperations().releaseShared(type, resourceId);
                    }
                };
                return coreAPILock;
            }
            if (container instanceof Relationship) {
                statement.readOperations().acquireShared(ResourceTypes.RELATIONSHIP, ((Relationship)container).getId());
                CoreAPILock coreAPILock = new CoreAPILock(stmtProvider, ResourceTypes.RELATIONSHIP, ((Node)container).getId()){

                    @Override
                    void release(Statement statement, Locks.ResourceType type, long resourceId) {
                        statement.readOperations().releaseShared(type, resourceId);
                    }
                };
                return coreAPILock;
            }
            try {
                throw new UnsupportedOperationException("Only relationships and nodes can be locked.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static abstract class CoreAPILock
    implements Lock {
        private final Provider<Statement> stmtProvider;
        private final Locks.ResourceType type;
        private final long resourceId;
        private boolean released = false;

        public CoreAPILock(Provider<Statement> stmtProvider, Locks.ResourceType type, long resourceId) {
            this.stmtProvider = stmtProvider;
            this.type = type;
            this.resourceId = resourceId;
        }

        @Override
        public void release() {
            if (this.released) {
                throw new IllegalStateException("Already released");
            }
            this.released = true;
            try (Statement statement = this.stmtProvider.instance();){
                this.release(statement, this.type, this.resourceId);
            }
        }

        abstract void release(Statement var1, Locks.ResourceType var2, long var3);
    }
}

