/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa.command;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.xa.PropertyRecordChange;
import org.neo4j.kernel.impl.nioneo.xa.command.CommandRecordVisitor;
import org.neo4j.kernel.impl.nioneo.xa.command.NeoCommandVisitor;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public abstract class Command
extends XaCommand {
    private int keyHash;
    private long key;
    private Mode mode;

    protected final void setup(long key, Mode mode) {
        this.mode = mode;
        this.keyHash = (int)(key >>> 32 ^ key);
        this.key = key;
    }

    public abstract void accept(CommandRecordVisitor var1);

    public int hashCode() {
        return this.keyHash;
    }

    public abstract String toString();

    public long getKey() {
        return this.key;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean equals(Object o) {
        return o != null && o.getClass().equals(this.getClass()) && this.getKey() == ((Command)o).getKey();
    }

    public abstract boolean accept(NeoCommandVisitor var1) throws IOException;

    public abstract void applyToCache(CacheAccessBackDoor var1);

    public static class SchemaRuleCommand
    extends Command {
        private Collection<DynamicRecord> recordsBefore;
        private Collection<DynamicRecord> recordsAfter;
        private SchemaRule schemaRule;
        private long txId;

        public SchemaRuleCommand init(Collection<DynamicRecord> recordsBefore, Collection<DynamicRecord> recordsAfter, SchemaRule schemaRule, long txId) {
            this.setup(IteratorUtil.first(recordsAfter).getId(), Mode.fromRecordState(IteratorUtil.first(recordsAfter)));
            this.recordsBefore = recordsBefore;
            this.recordsAfter = recordsAfter;
            this.schemaRule = schemaRule;
            this.txId = txId;
            return this;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitSchemaRule(this.recordsAfter);
        }

        @Override
        public String toString() {
            if (this.schemaRule != null) {
                return (Object)((Object)this.getMode()) + ":" + this.schemaRule.toString();
            }
            return "SchemaRule" + this.recordsAfter;
        }

        @Override
        public boolean accept(NeoCommandVisitor visitor) throws IOException {
            return visitor.visitSchemaRuleCommand(this);
        }

        @Override
        public void applyToCache(CacheAccessBackDoor cacheAccess) {
            cacheAccess.removeSchemaRuleFromCache(this.getKey());
        }

        public Collection<DynamicRecord> getRecordsAfter() {
            return Collections.unmodifiableCollection(this.recordsAfter);
        }

        public SchemaRule getSchemaRule() {
            return this.schemaRule;
        }

        public long getTxId() {
            return this.txId;
        }

        public void setTxId(long txId) {
            this.txId = txId;
        }

        public Collection<DynamicRecord> getRecordsBefore() {
            return this.recordsBefore;
        }
    }

    public static class LabelTokenCommand
    extends Command {
        private LabelTokenRecord record;

        public LabelTokenCommand init(LabelTokenRecord record) {
            this.setup(record.getId(), Mode.fromRecordState(record));
            this.record = record;
            return this;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitLabelToken(this.record);
        }

        @Override
        public String toString() {
            return this.record.toString();
        }

        @Override
        public boolean accept(NeoCommandVisitor visitor) throws IOException {
            return visitor.visitLabelTokenCommand(this);
        }

        @Override
        public void applyToCache(CacheAccessBackDoor cacheAccess) {
        }

        public LabelTokenRecord getRecord() {
            return this.record;
        }
    }

    public static class RelationshipTypeTokenCommand
    extends Command {
        private RelationshipTypeTokenRecord record;

        public RelationshipTypeTokenCommand init(RelationshipTypeTokenRecord record) {
            this.setup(record.getId(), Mode.fromRecordState(record));
            this.record = record;
            return this;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitRelationshipTypeToken(this.record);
        }

        @Override
        public String toString() {
            return this.record.toString();
        }

        @Override
        public boolean accept(NeoCommandVisitor visitor) throws IOException {
            return visitor.visitRelationshipTypeTokenCommand(this);
        }

        @Override
        public void applyToCache(CacheAccessBackDoor cacheAccess) {
        }

        public RelationshipTypeTokenRecord getRecord() {
            return this.record;
        }
    }

    public static class PropertyCommand
    extends Command
    implements PropertyRecordChange {
        private PropertyRecord before;
        private PropertyRecord after;

        public PropertyCommand init(PropertyRecord before, PropertyRecord after) {
            this.setup(after.getId(), Mode.fromRecordState(after));
            this.before = before;
            this.after = after;
            return this;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitProperty(this.after);
        }

        @Override
        public String toString() {
            return this.after.toString();
        }

        @Override
        public boolean accept(NeoCommandVisitor visitor) throws IOException {
            return visitor.visitPropertyCommand(this);
        }

        @Override
        public void applyToCache(CacheAccessBackDoor cacheAccess) {
            long nodeId = this.getNodeId();
            long relId = this.getRelId();
            if (nodeId != -1L) {
                cacheAccess.removeNodeFromCache(nodeId);
            } else if (relId != -1L) {
                cacheAccess.removeRelationshipFromCache(relId);
            }
        }

        @Override
        public PropertyRecord getBefore() {
            return this.before;
        }

        @Override
        public PropertyRecord getAfter() {
            return this.after;
        }

        public long getNodeId() {
            return this.after.getNodeId();
        }

        public long getRelId() {
            return this.after.getRelId();
        }
    }

    public static class PropertyKeyTokenCommand
    extends Command {
        private PropertyKeyTokenRecord record;

        public PropertyKeyTokenCommand init(PropertyKeyTokenRecord record) {
            this.setup(record.getId(), Mode.fromRecordState(record));
            this.record = record;
            return this;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitPropertyKeyToken(this.record);
        }

        @Override
        public String toString() {
            return this.record.toString();
        }

        @Override
        public boolean accept(NeoCommandVisitor visitor) throws IOException {
            return visitor.visitPropertyKeyTokenCommand(this);
        }

        @Override
        public void applyToCache(CacheAccessBackDoor cacheAccess) {
        }

        public PropertyKeyTokenRecord getRecord() {
            return this.record;
        }
    }

    public static class NeoStoreCommand
    extends Command {
        private NeoStoreRecord record;

        public NeoStoreCommand init(NeoStoreRecord record) {
            if (record != null) {
                this.setup(record.getId(), Mode.fromRecordState(record));
            }
            this.record = record;
            return this;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitNeoStore(this.record);
        }

        @Override
        public String toString() {
            return this.record.toString();
        }

        @Override
        public boolean accept(NeoCommandVisitor visitor) throws IOException {
            return visitor.visitNeoStoreCommand(this);
        }

        @Override
        public void applyToCache(CacheAccessBackDoor cacheAccess) {
        }

        public NeoStoreRecord getRecord() {
            return this.record;
        }
    }

    public static class RelationshipGroupCommand
    extends Command {
        private RelationshipGroupRecord record;

        public RelationshipGroupCommand init(RelationshipGroupRecord record) {
            this.setup(record.getId(), Mode.fromRecordState(record));
            this.record = record;
            return this;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitRelationshipGroup(this.record);
        }

        @Override
        public void applyToCache(CacheAccessBackDoor cacheAccess) {
        }

        @Override
        public String toString() {
            return this.record.toString();
        }

        @Override
        public boolean accept(NeoCommandVisitor visitor) throws IOException {
            return visitor.visitRelationshipGroupCommand(this);
        }

        public RelationshipGroupRecord getRecord() {
            return this.record;
        }
    }

    public static class RelationshipCommand
    extends Command {
        private RelationshipRecord record;
        private RelationshipRecord beforeUpdate;
        private RelationshipRecord before;

        public RelationshipCommand init(RelationshipRecord record) {
            this.setup(record.getId(), Mode.fromRecordState(record));
            this.record = record;
            this.beforeUpdate = record;
            return this;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitRelationship(this.record);
        }

        @Override
        public String toString() {
            return this.record.toString();
        }

        @Override
        public boolean accept(NeoCommandVisitor visitor) throws IOException {
            return visitor.visitRelationshipCommand(this);
        }

        public RelationshipRecord getRecord() {
            return this.record;
        }

        @Override
        public void applyToCache(CacheAccessBackDoor cacheAccess) {
            cacheAccess.removeRelationshipFromCache(this.getKey());
            if (this.beforeUpdate.getFirstNode() != -1L || this.beforeUpdate.getSecondNode() != -1L) {
                cacheAccess.patchDeletedRelationshipNodes(this.getKey(), this.beforeUpdate.getFirstNode(), this.beforeUpdate.getFirstNextRel(), this.beforeUpdate.getSecondNode(), this.beforeUpdate.getSecondNextRel());
            }
            if (this.record.getFirstNode() != -1L || this.record.getSecondNode() != -1L) {
                cacheAccess.removeNodeFromCache(this.record.getFirstNode());
                cacheAccess.removeNodeFromCache(this.record.getSecondNode());
            }
        }

        public void setBefore(RelationshipRecord before) {
            this.before = before;
        }
    }

    public static class NodeCommand
    extends Command {
        private NodeRecord before;
        private NodeRecord after;

        public NodeCommand init(NodeRecord before, NodeRecord after) {
            this.setup(after.getId(), Mode.fromRecordState(after));
            this.before = before;
            this.after = after;
            return this;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitNode(this.after);
        }

        @Override
        public boolean accept(NeoCommandVisitor visitor) throws IOException {
            return visitor.visitNodeCommand(this);
        }

        @Override
        public String toString() {
            return this.after.toString();
        }

        @Override
        public void applyToCache(CacheAccessBackDoor cacheAccess) {
            cacheAccess.removeNodeFromCache(this.getKey());
        }

        public NodeRecord getBefore() {
            return this.before;
        }

        public NodeRecord getAfter() {
            return this.after;
        }
    }

    public static enum Mode {
        CREATE,
        UPDATE,
        DELETE;


        public static Mode fromRecordState(boolean created, boolean inUse) {
            if (!inUse) {
                return DELETE;
            }
            if (created) {
                return CREATE;
            }
            return UPDATE;
        }

        public static Mode fromRecordState(AbstractBaseRecord record) {
            return Mode.fromRecordState(record.isCreated(), record.inUse());
        }
    }
}

