/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.nioneo.xa.command.NeoCommandVisitor;
import org.neo4j.kernel.impl.nioneo.xa.command.XaCommandExecutor;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public class NeoXaCommandExecutor
implements XaCommandExecutor {
    private final NeoCommandExecutor executingVisitor = new NeoCommandExecutor();
    private NeoStore store;
    private IndexingService indexes;

    public NeoXaCommandExecutor(NeoStore store, IndexingService indexes) {
        this.store = store;
        this.indexes = indexes;
    }

    @Override
    public void execute(XaCommand command) throws IOException {
        ((Command)command).accept(this.executingVisitor);
    }

    private class NeoCommandExecutor
    implements NeoCommandVisitor {
        private NeoCommandExecutor() {
        }

        @Override
        public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
            NeoXaCommandExecutor.this.store.getNodeStore().updateRecord(command.getAfter());
            ArrayList<DynamicRecord> toUpdate = new ArrayList<DynamicRecord>(command.getAfter().getDynamicLabelRecords());
            HashSet<Long> idsToRemove = new HashSet<Long>();
            for (DynamicRecord record : command.getBefore().getDynamicLabelRecords()) {
                idsToRemove.add(record.getId());
            }
            for (DynamicRecord record : command.getAfter().getDynamicLabelRecords()) {
                idsToRemove.remove(record.getId());
            }
            Iterator<DynamicRecord> i$ = idsToRemove.iterator();
            while (i$.hasNext()) {
                long id = (Long)((Object)i$.next());
                toUpdate.add(new DynamicRecord(id));
            }
            NeoXaCommandExecutor.this.store.getNodeStore().updateDynamicLabelRecords(toUpdate);
            return true;
        }

        @Override
        public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
            RelationshipRecord record = command.getRecord();
            if (command.isRecovered() && !record.inUse()) {
                command.setBefore(NeoXaCommandExecutor.this.store.getRelationshipStore().forceGetRaw(record.getId()));
            }
            NeoXaCommandExecutor.this.store.getRelationshipStore().updateRecord(record);
            return true;
        }

        @Override
        public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
            NeoXaCommandExecutor.this.store.getPropertyStore().updateRecord(command.getAfter());
            return true;
        }

        @Override
        public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
            if (command.isRecovered()) {
                NeoXaCommandExecutor.this.store.getRelationshipGroupStore().updateRecord(command.getRecord(), true);
            } else {
                NeoXaCommandExecutor.this.store.getRelationshipGroupStore().updateRecord(command.getRecord());
            }
            return true;
        }

        @Override
        public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
            NeoXaCommandExecutor.this.store.getRelationshipTypeTokenStore().updateRecord(command.getRecord());
            return true;
        }

        @Override
        public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
            NeoXaCommandExecutor.this.store.getLabelTokenStore().updateRecord(command.getRecord());
            return true;
        }

        @Override
        public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
            NeoXaCommandExecutor.this.store.getPropertyStore().getPropertyKeyTokenStore().updateRecord(command.getRecord());
            return true;
        }

        @Override
        public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
            for (DynamicRecord record : command.getRecordsAfter()) {
                NeoXaCommandExecutor.this.store.getSchemaStore().updateRecord(record);
            }
            if (command.getSchemaRule() instanceof IndexRule) {
                switch (command.getMode()) {
                    case UPDATE: {
                        if (!((IndexRule)command.getSchemaRule()).isConstraintIndex()) break;
                        try {
                            NeoXaCommandExecutor.this.indexes.activateIndex(command.getSchemaRule().getId());
                            break;
                        }
                        catch (IndexActivationFailedKernelException | IndexNotFoundKernelException | IndexPopulationFailedKernelException e) {
                            throw new IllegalStateException("Unable to enable constraint, backing index is not online.", e);
                        }
                    }
                    case CREATE: {
                        NeoXaCommandExecutor.this.indexes.createIndex((IndexRule)command.getSchemaRule());
                        break;
                    }
                    case DELETE: {
                        NeoXaCommandExecutor.this.indexes.dropIndex((IndexRule)command.getSchemaRule());
                        break;
                    }
                    default: {
                        throw new IllegalStateException(command.getMode().name());
                    }
                }
            }
            if (command.getSchemaRule() instanceof UniquenessConstraintRule) {
                switch (command.getMode()) {
                    case UPDATE: 
                    case CREATE: {
                        NeoXaCommandExecutor.this.store.setLatestConstraintIntroducingTx(command.getTxId());
                        break;
                    }
                    case DELETE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException(command.getMode().name());
                    }
                }
            }
            return true;
        }

        @Override
        public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) throws IOException {
            NeoXaCommandExecutor.this.store.setGraphNextProp(command.getRecord().getNextProp());
            return true;
        }
    }
}

