/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.StoreFile20;

public class LogFiles {
    public static void move(FileSystemAbstraction fs, File fromDirectory, File toDirectory) throws IOException {
        assert (fs.isDirectory(fromDirectory));
        assert (fs.isDirectory(toDirectory));
        LogicalLogFilenameFilter filter = new LogicalLogFilenameFilter();
        for (File logFile : fs.listFiles(fromDirectory)) {
            if (!filter.accept(fromDirectory, logFile.getName())) continue;
            StoreFile20.moveFile(fs, logFile.getName(), fromDirectory, toDirectory, false, false);
        }
    }

    private static final class LogicalLogFilenameFilter
    implements FilenameFilter {
        private static final String[] logFilenamePatterns = new String[]{"active_tx_log", "nioneo_logical\\.log.*", "tm_tx_log\\..*"};

        private LogicalLogFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            for (String pattern : logFilenamePatterns) {
                if (!name.matches(pattern)) continue;
                return true;
            }
            return false;
        }
    }
}

