/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v19;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.Legacy19Store;

public class LegacyDynamicStringStoreReader {
    private final int blockSize;
    private final StoreChannel fileChannel;
    private final ByteBuffer blockBuffer;
    private ByteBuffer chainBuffer;

    public LegacyDynamicStringStoreReader(FileSystemAbstraction fs, File fileName, String fromVersion) throws IOException {
        this.fileChannel = fs.open(fileName, "r");
        long fileSize = this.fileChannel.size();
        byte[] version = new byte[UTF8.encode(fromVersion).length];
        ByteBuffer buffer = ByteBuffer.wrap(version);
        this.fileChannel.position(fileSize - (long)version.length);
        this.fileChannel.read(buffer);
        buffer = ByteBuffer.allocate(4);
        this.fileChannel.position(0L);
        this.fileChannel.read(buffer);
        buffer.flip();
        this.blockSize = buffer.getInt();
        this.blockBuffer = ByteBuffer.allocate(this.blockSize);
        this.chainBuffer = ByteBuffer.wrap(new byte[this.blockSize * 3]);
    }

    public String readDynamicString(long startRecordId) throws IOException {
        long blockId = startRecordId;
        this.chainBuffer.clear();
        while (blockId != (long)Record.NO_NEXT_BLOCK.intValue()) {
            this.fileChannel.position(blockId * (long)this.blockSize);
            Legacy19Store.readIntoBuffer(this.fileChannel, this.blockBuffer, this.blockSize);
            this.ensureChainBufferBigEnough();
            blockId = this.readRecord(blockId, this.blockBuffer);
        }
        return UTF8.decode(this.chainBuffer.array(), 0, this.chainBuffer.position());
    }

    private void ensureChainBufferBigEnough() {
        if (this.chainBuffer.remaining() < this.blockSize) {
            byte[] extendedBuffer = new byte[this.chainBuffer.capacity() * 2];
            System.arraycopy(this.chainBuffer.array(), 0, extendedBuffer, 0, this.chainBuffer.capacity());
            this.chainBuffer = ByteBuffer.wrap(extendedBuffer);
        }
    }

    private long readRecord(long blockId, ByteBuffer recordData) {
        boolean inUse;
        long firstInteger = Legacy19Store.getUnsignedInt(recordData);
        long maskedInteger = firstInteger & Integer.MAX_VALUE;
        int highNibbleInMaskedInteger = (int)(maskedInteger >> 28);
        boolean bl = inUse = highNibbleInMaskedInteger == Record.IN_USE.intValue();
        if (!inUse) {
            throw new InvalidRecordException("DynamicRecord not in use, blockId[" + blockId + "]");
        }
        int nrOfBytes = (int)(firstInteger & 0xFFFFFFL);
        long nextBlock = Legacy19Store.getUnsignedInt(recordData);
        long nextModifier = (firstInteger & 0xF000000L) << 8;
        long longNextBlock = Legacy19Store.longFromIntAndMod(nextBlock, nextModifier);
        recordData.limit(recordData.position() + nrOfBytes);
        this.chainBuffer.put(recordData);
        return longNextBlock;
    }

    public void close() throws IOException {
        this.fileChannel.close();
    }
}

